/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.constraints.builtinconstraints;

import java.io.InputStream;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.Resource;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Resource(source="builtin-constraints-override.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/constraints/builtinconstraints/builtin-constraints-override.xml")
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class BuiltinValidatorOverrideTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="6", id="b")
    public void testXmlConfiguredValidatorConfigurationHasPrecedence() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        InputStream in = TestUtil.getInputStreamForPath("org/hibernate/jsr303/tck/tests/constraints/builtinconstraints/builtin-constraints-override.xml");
        config.addMapping(in);
        Validator validator = config.buildValidatorFactory().getValidator();
        DummyEntity dummy = new DummyEntity();
        Set violations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        dummy.dummyProperty = "foobar";
        violations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
    }

    class DummyEntity {
        @NotNull
        String dummyProperty;

        DummyEntity() {
        }
    }
}

