/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.constraints.constraintdefinition;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.jsr303.tck.tests.constraints.constraintdefinition.AlwaysValid;
import org.hibernate.jsr303.tck.tests.constraints.constraintdefinition.Person;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class ConstraintDefinitionsTest
extends AbstractTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.1.1", id="a"), @SpecAssertion(section="2.2", id="a")})
    public void testConstraintWithCustomAttributes() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set descriptors = validator.getConstraintsForClass(Person.class).getConstraintsForProperty("lastName").getConstraintDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)2, (String)"There should be two constraints on the lastName property.");
        for (ConstraintDescriptor descriptor : descriptors) {
            Assert.assertEquals((String)descriptor.getAnnotation().annotationType().getName(), (String)AlwaysValid.class.getName(), (String)"Wrong annotation type.");
        }
        Set constraintViolations = validator.validate((Object)new Person("John", "Doe"), new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
    }

    @Test
    @SpecAssertion(section="2.1.1", id="f")
    public void testDefaultGroupAssumedWhenNoGroupsSpecified() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ConstraintDescriptor descriptor = (ConstraintDescriptor)validator.getConstraintsForClass(Person.class).getConstraintsForProperty("firstName").getConstraintDescriptors().iterator().next();
        Set groups = descriptor.getGroups();
        Assert.assertEquals((int)groups.size(), (int)1, (String)"The group set should only contain one entry.");
        Assert.assertEquals(groups.iterator().next(), Default.class, (String)"The Default group should be returned.");
    }
}

