/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.constraints.customconstraint;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.UnexpectedTypeException;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.jsr303.tck.tests.constraints.customconstraint.Author;
import org.hibernate.jsr303.tck.tests.constraints.customconstraint.BoundariesConstraintValidator;
import org.hibernate.jsr303.tck.tests.constraints.customconstraint.Negative;
import org.hibernate.jsr303.tck.tests.constraints.customconstraint.Positive;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class CustomConstraintValidatorTest
extends AbstractTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.4", id="a"), @SpecAssertion(section="2.4", id="b"), @SpecAssertion(section="2.4", id="e")})
    public void testRightValidatorIsSelectedAndInitializedCalled() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Shoe shoe = new Shoe();
        shoe.size = -2;
        PropertyDescriptor propertyDescriptor = validator.getConstraintsForClass(Shoe.class).getConstraintsForProperty("size");
        Assert.assertNotNull((Object)propertyDescriptor);
        BoundariesConstraintValidator.isValidCalls = 0;
        Set constraintViolations = validator.validate((Object)shoe, new Class[0]);
        Assert.assertEquals((int)1, (int)constraintViolations.size());
        Assert.assertTrue((BoundariesConstraintValidator.isValidCalls >= 1 ? 1 : 0) != 0, (String)"Ensure the right validator implementation class was picked.");
        Assert.assertTrue((boolean)BoundariesConstraintValidator.initializeCalled, (String)"Check initialize was called. Note this is not really ensuring that it was called before isValid. That is done in the actual implementation of the validator.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.4", id="a"), @SpecAssertion(section="2.4", id="b"), @SpecAssertion(section="2.4", id="f")})
    public void testIsValidIsCalledForEachValidation() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Shoe shoe = new Shoe();
        shoe.size = -2;
        int nbrOfValidCalls = 0;
        BoundariesConstraintValidator.isValidCalls = 0;
        validator.validate((Object)shoe, new Class[0]);
        Assert.assertTrue((BoundariesConstraintValidator.isValidCalls > nbrOfValidCalls ? 1 : 0) != 0, (String)"Ensure is valid has been called.");
        nbrOfValidCalls = BoundariesConstraintValidator.isValidCalls;
        validator.validate((Object)shoe, new Class[0]);
        Assert.assertTrue((BoundariesConstraintValidator.isValidCalls > nbrOfValidCalls ? 1 : 0) != 0, (String)"Ensure is valid has been called.");
        nbrOfValidCalls = BoundariesConstraintValidator.isValidCalls;
        validator.validateProperty((Object)shoe, "size", new Class[0]);
        Assert.assertTrue((BoundariesConstraintValidator.isValidCalls > nbrOfValidCalls ? 1 : 0) != 0, (String)"Ensure is valid has been called.");
        nbrOfValidCalls = BoundariesConstraintValidator.isValidCalls;
        validator.validateValue(Shoe.class, "size", (Object)41, new Class[0]);
        Assert.assertTrue((BoundariesConstraintValidator.isValidCalls > nbrOfValidCalls ? 1 : 0) != 0, (String)"Ensure is valid has been called.");
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertion(section="2.4", id="i")
    public void testUnexpectedTypeExceptionIsRaisedForInvalidType() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new OddShoe(), new Class[0]);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="2.4", id="j")
    public void testRuntimeExceptionFromIsValidIsWrapped() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Shoe shoe = new Shoe();
        shoe.size = -2;
        BoundariesConstraintValidator.throwRuntimeExceptionFromIsValid = true;
        validator.validate((Object)shoe, new Class[0]);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="2.4", id="j")
    public void testRuntimeExceptionFromInitializeIsWrapped() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new Freezer(), new Class[0]);
    }

    @Test
    @SpecAssertion(section="2.4", id="l")
    public void testOneConstraintViolationPerFailingConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Author author = new Author();
        author.setLastName("");
        author.setFirstName("");
        author.setCompany("");
        Set constraintViolations = validator.validate((Object)author, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 3);
        author.setFirstName("John");
        constraintViolations = validator.validate((Object)author, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        author.setLastName("Doe");
        constraintViolations = validator.validate((Object)author, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        author.setCompany("JBoss");
        constraintViolations = validator.validate((Object)author, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="2.4", id="n")
    public void testNonInterpolatedMessageParameterIsUsed() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Author author = new Author();
        author.setLastName("John");
        author.setFirstName("Doe");
        author.setCompany("");
        Set constraintViolations = validator.validate((Object)author, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((String)constraintViolation.getMessage(), (String)"The company name must be a minimum 3 characters");
        Assert.assertEquals((String)constraintViolation.getMessageTemplate(), (String)"The company name must be a minimum {min} characters");
        Assert.assertTrue((!constraintViolation.getMessageTemplate().equals(constraintViolation.getMessage()) ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertion(section="2.4", id="o")
    public void testDefaultPropertyPath() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Author author = new Author();
        author.setLastName("John");
        author.setFirstName("Doe");
        author.setCompany("");
        Set constraintViolations = validator.validate((Object)author, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "company");
    }

    public static class Freezer {
        @Negative
        public int temperature;
    }

    public static class OddShoe {
        @Positive
        public String size;
    }

    public static class Shoe {
        @Positive
        public int size;
    }
}

