/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.constraints.groups;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.hibernate.jsr303.tck.tests.constraints.groups.Address;
import org.hibernate.jsr303.tck.tests.constraints.groups.Car;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class DefaultGroupRedefinitionTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="3.4.3", id="a")
    public void testRedefiningDefaultGroup() {
        Address address = new Address();
        address.setStreet("Guldmyntgatan");
        address.setCity("Gothenborg");
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
        TestUtil.assertConstraintViolation(violation, Address.class, null, "zipcode");
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Zipcode may not be null");
        address.setZipcode("41841");
        constraintViolations = validator.validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        violation = (ConstraintViolation)constraintViolations.iterator().next();
        TestUtil.assertConstraintViolation(violation, Address.class, address, "");
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Zip code is not coherent.");
    }

    @Test
    @SpecAssertion(section="3.4.3", id="a")
    public void testValidatingAgainstRedefinedDefaultGroup() {
        Car car = new Car();
        car.setType("A");
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)car, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Car type has to be between 2 and 20 characters.");
        constraintViolations = validator.validateProperty((Object)car, "type", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Car type has to be between 2 and 20 characters.");
        constraintViolations = validator.validateValue(Car.class, "type", (Object)"A", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Car type has to be between 2 and 20 characters.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4.3", id="c"), @SpecAssertion(section="3.4.3", id="d")})
    public void testGroupSequenceContainingDefault() {
        AddressWithDefaultInGroupSequence address = new AddressWithDefaultInGroupSequence();
        Validator validator = TestUtil.getValidatorUnderTest();
        try {
            validator.validate((Object)address, new Class[0]);
            Assert.fail((String)"It should not be allowed to have Default.class in the group sequence of a class.");
        }
        catch (GroupDefinitionException groupDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4.3", id="c"), @SpecAssertion(section="3.4.3", id="d")})
    public void testGroupSequenceWithNoImplicitDefaultGroup() {
        AddressWithNoImplicitDefaultGroupSequence address = new AddressWithNoImplicitDefaultGroupSequence();
        Validator validator = TestUtil.getValidatorUnderTest();
        try {
            validator.validate((Object)address, new Class[0]);
            Assert.fail((String)"A valid group sequence definition must contain the class itself as implicit default group.");
        }
        catch (GroupDefinitionException groupDefinitionException) {
            // empty catch block
        }
    }

    private void assertAssertionType(Set<ConstraintViolation<Address>> violations) {
        for (ConstraintViolation<Address> violation : violations) {
            Annotation ann = violation.getConstraintDescriptor().getAnnotation();
            Assert.assertEquals(NotNull.class, ann.annotationType(), (String)"Wrong assertion type");
        }
    }

    @GroupSequence(value={Address.HighLevelCoherence.class})
    public class AddressWithNoImplicitDefaultGroupSequence
    extends Address {
    }

    @GroupSequence(value={Default.class, Address.HighLevelCoherence.class})
    public class AddressWithDefaultInGroupSequence
    extends Address {
    }
}

