/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.constraints.groups.groupsequence;

import java.util.Set;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.jsr303.tck.tests.constraints.groups.groupsequence.Complete;
import org.hibernate.jsr303.tck.tests.constraints.groups.groupsequence.TestEntity;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class SequenceResolutionTest
extends AbstractTest {
    @Test(expectedExceptions={GroupDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.4.2", id="e"), @SpecAssertion(section="3.4.2", id="f"), @SpecAssertion(section="3.4.2", id="i"), @SpecAssertion(section="8.4", id="a")})
    public void testInvalidDefinitionOfDefaultSequenceInEntity() {
        Validator validator = TestUtil.getValidatorUnderTest();
        TestEntity entity = new TestEntity();
        validator.validate((Object)entity, new Class[]{Complete.class});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4.2", id="c")})
    public void testGroupSequenceContainerOtherGroupSequences() {
        Validator validator = TestUtil.getValidatorUnderTest();
        TestEntity entity = new TestEntity();
        try {
            validator.validate((Object)entity, new Class[]{InvalidGroupSequence.class});
        }
        catch (GroupDefinitionException groupDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="3.4.2", id="j")
    public void testOnlyFirstGroupInSequenceGetEvaluated() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Car car = new Car("USd-298");
        Set violations = validator.validate((Object)car, new Class[]{First.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        violations = validator.validate((Object)car, new Class[]{Second.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        violations = validator.validate((Object)car, new Class[]{All.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        violations = validator.validate((Object)car, new Class[]{AllReverse.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
    }

    @GroupSequence(value={First.class, Third.class, Mixed.class})
    static interface InvalidGroupSequence {
    }

    @GroupSequence(value={Second.class, Third.class, First.class})
    static interface Mixed {
    }

    @GroupSequence(value={Third.class, Second.class, First.class})
    static interface AllReverse {
    }

    @GroupSequence(value={First.class, Second.class, Third.class})
    static interface All {
    }

    static interface Third {
    }

    static interface Second {
    }

    static interface First {
    }

    class Car {
        @Pattern(regexp="[A-Z][A-Z][A-Z]-[0-9][0-9][0-9]", groups={First.class, Second.class})
        private String licensePlateNumber;
        @NotNull(groups={Second.class})
        private String make;

        Car(String licensePlateNumber) {
            this.licensePlateNumber = licensePlateNumber;
        }

        public String getLicensePlateNumber() {
            return this.licensePlateNumber;
        }
    }
}

