/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.constraints.groups.inheritance;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class GroupInheritanceTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="3.4.1", id="a")
    public void testGroupCanInheritGroupsViaInterfaceInheritance() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Part part = new Part();
        part.setPartNumber(123456);
        Set violations = validator.validate((Object)part, new Class[]{All.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Digits.class, AssertTrue.class);
        part.setPartNumber(12345);
        part.setQaChecked(true);
        violations = validator.validate((Object)part, new Class[]{All.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertion(section="3.4.1", id="b")
    public void testGroupMembership() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor descriptor = validator.getConstraintsForClass(MiniaturePart.class);
        PropertyDescriptor propertyDescriptor = descriptor.getConstraintsForProperty("partNumber");
        Set descriptorsForGroup = propertyDescriptor.findConstraints().unorderedAndMatchingGroups(new Class[]{All.class}).getConstraintDescriptors();
        Assert.assertEquals((int)descriptorsForGroup.size(), (int)1, (String)"Wrong number of descriptors");
        Assert.assertEquals(((ConstraintDescriptor)descriptorsForGroup.iterator().next()).getAnnotation().annotationType(), Digits.class);
        propertyDescriptor = descriptor.getConstraintsForProperty("qaChecked");
        descriptorsForGroup = propertyDescriptor.findConstraints().unorderedAndMatchingGroups(new Class[]{All.class}).getConstraintDescriptors();
        Assert.assertEquals((int)descriptorsForGroup.size(), (int)1, (String)"Wrong number of descriptors");
        Assert.assertEquals(((ConstraintDescriptor)descriptorsForGroup.iterator().next()).getAnnotation().annotationType(), AssertTrue.class);
        propertyDescriptor = descriptor.getConstraintsForProperty("size");
        descriptorsForGroup = propertyDescriptor.findConstraints().unorderedAndMatchingGroups(new Class[]{All.class}).getConstraintDescriptors();
        Assert.assertEquals((int)descriptorsForGroup.size(), (int)1, (String)"Wrong number of descriptors");
        Assert.assertEquals(((ConstraintDescriptor)descriptorsForGroup.iterator().next()).getAnnotation().annotationType(), Max.class);
    }

    static interface All
    extends PreManufacturing,
    PostManufacturing {
    }

    static interface PostManufacturing {
    }

    static interface PreManufacturing {
    }

    class MiniaturePart
    extends Part {
        @Max(value=10L, groups={All.class})
        private int size;

        MiniaturePart() {
        }
    }

    class Part {
        @Digits(integer=5, fraction=0, groups={PreManufacturing.class})
        private int partNumber;
        @AssertTrue(groups={PostManufacturing.class})
        private boolean qaChecked;

        Part() {
        }

        public int getPartNumber() {
            return this.partNumber;
        }

        public void setPartNumber(int partNumber) {
            this.partNumber = partNumber;
        }

        public boolean getQaChecked() {
            return this.qaChecked;
        }

        public void setQaChecked(boolean qaChecked) {
            this.qaChecked = qaChecked;
        }
    }
}

