/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.constraints.inheritance;

import java.lang.annotation.Annotation;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.jsr303.tck.tests.constraints.inheritance.Bar;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class ConstraintInheritanceTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="3.3", id="b")
    public void testConstraintsOnSuperClassAreInherited() {
        String propertyName;
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Bar.class);
        Assert.assertTrue((beanDescriptor.getConstraintsForProperty(propertyName = "foo") != null ? 1 : 0) != 0);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty(propertyName);
        Annotation constraintAnnotation = ((ConstraintDescriptor)propDescriptor.getConstraintDescriptors().iterator().next()).getAnnotation();
        Assert.assertTrue((constraintAnnotation.annotationType() == NotNull.class ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.3", id="a"), @SpecAssertion(section="3.3", id="b")})
    public void testConstraintsOnInterfaceAreInherited() {
        String propertyName;
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Bar.class);
        Assert.assertTrue((beanDescriptor.getConstraintsForProperty(propertyName = "fubar") != null ? 1 : 0) != 0);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty(propertyName);
        Annotation constraintAnnotation = ((ConstraintDescriptor)propDescriptor.getConstraintDescriptors().iterator().next()).getAnnotation();
        Assert.assertTrue((constraintAnnotation.annotationType() == NotNull.class ? 1 : 0) != 0);
    }
}

