/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.constraints.invalidconstraintdefinitions;

import javax.validation.ConstraintDefinitionException;
import javax.validation.Validator;
import org.hibernate.jsr303.tck.tests.constraints.invalidconstraintdefinitions.InvalidDefaultGroup;
import org.hibernate.jsr303.tck.tests.constraints.invalidconstraintdefinitions.InvalidDefaultPayload;
import org.hibernate.jsr303.tck.tests.constraints.invalidconstraintdefinitions.InvalidGroupsType;
import org.hibernate.jsr303.tck.tests.constraints.invalidconstraintdefinitions.InvalidMessageType;
import org.hibernate.jsr303.tck.tests.constraints.invalidconstraintdefinitions.InvalidPayloadClass;
import org.hibernate.jsr303.tck.tests.constraints.invalidconstraintdefinitions.NoGroups;
import org.hibernate.jsr303.tck.tests.constraints.invalidconstraintdefinitions.NoMessage;
import org.hibernate.jsr303.tck.tests.constraints.invalidconstraintdefinitions.NoPayload;
import org.hibernate.jsr303.tck.tests.constraints.invalidconstraintdefinitions.ValidInPropertyName;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class InvalidConstraintDefinitionsTest
extends AbstractTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.1", id="d"), @SpecAssertion(section="2.1.1", id="b"), @SpecAssertion(section="8.2", id="a")})
    public void testConstraintDefinitionWithParameterStartingWithValid() {
        try {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new DummyEntityValidProperty(), new Class[0]);
            Assert.fail((String)"The used constraint does use an invalid property name. The validation should have failed.");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.1", id="c"), @SpecAssertion(section="2.1.1", id="c"), @SpecAssertion(section="4.3.1", id="b"), @SpecAssertion(section="4.3.1", id="c"), @SpecAssertion(section="8.2", id="a")})
    public void testConstraintDefinitionWithoutMessageParameter() {
        try {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new DummyEntityNoMessage(), new Class[0]);
            Assert.fail((String)"The used constraint does not define a message parameter. The validation should have failed.");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.1", id="c"), @SpecAssertion(section="2.1.1", id="d"), @SpecAssertion(section="8.2", id="a")})
    public void testConstraintDefinitionWithoutGroupParameter() {
        try {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new DummyEntityNoGroups(), new Class[0]);
            Assert.fail((String)"The used constraint does not define a groups parameter. The validation should have failed.");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.1", id="c"), @SpecAssertion(section="2.1.1", id="h"), @SpecAssertion(section="8.2", id="a")})
    public void testConstraintDefinitionWithoutPayloadParameter() {
        try {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new DummyEntityNoGroups(), new Class[0]);
            Assert.fail((String)"The used constraint does not define a payload parameter. The validation should have failed.");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.1", id="c"), @SpecAssertion(section="2.1.1", id="e"), @SpecAssertion(section="8.2", id="a")})
    public void testConstraintDefinitionWithWrongDefaultGroupValue() {
        try {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new DummyEntityInvalidDefaultGroup(), new Class[0]);
            Assert.fail((String)"The default groups parameter is not the empty array. The validation should have failed.");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.1", id="c"), @SpecAssertion(section="2.1.1", id="i"), @SpecAssertion(section="8.2", id="a")})
    public void testConstraintDefinitionWithWrongDefaultPayloadValue() {
        try {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new DummyEntityInvalidDefaultPayload(), new Class[0]);
            Assert.fail((String)"The default payload parameter is not the empty array. The validation should have failed.");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.1", id="c"), @SpecAssertion(section="2.1.1", id="j"), @SpecAssertion(section="8.2", id="a")})
    public void testConstraintDefinitionWithWrongPayloadClass() {
        try {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new DummyEntityInvalidPayloadClass(), new Class[0]);
            Assert.fail((String)"The default payload parameter has to be of type Class<? extends Payload>[]. The validation should have failed.");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.1", id="c"), @SpecAssertion(section="2.1.1", id="c"), @SpecAssertion(section="8.2", id="a")})
    public void testConstraintDefinitionWithWrongMessageType() {
        try {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new DummyEntityInvalidMessageType(), new Class[0]);
            Assert.fail((String)"The message parameter has to be of type String. The validation should have failed.");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.1", id="c"), @SpecAssertion(section="2.1.1", id="g"), @SpecAssertion(section="8.2", id="a")})
    public void testConstraintDefinitionWithWrongGroupType() {
        try {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new DummyEntityInvalidGroupsType(), new Class[0]);
            Assert.fail((String)"The groups parameter has to be of type Class<?>[]. The validation should have failed.");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    @InvalidGroupsType
    public class DummyEntityInvalidGroupsType {
    }

    @InvalidMessageType
    public class DummyEntityInvalidMessageType {
    }

    @InvalidPayloadClass
    public class DummyEntityInvalidPayloadClass {
    }

    @InvalidDefaultPayload
    public class DummyEntityInvalidDefaultPayload {
    }

    @NoPayload
    public class DummyEntityNoPayload {
    }

    @ValidInPropertyName
    public class DummyEntityValidProperty {
    }

    @NoMessage
    public class DummyEntityNoMessage {
    }

    @NoGroups
    public class DummyEntityNoGroups {
    }

    @InvalidDefaultGroup
    public class DummyEntityInvalidDefaultGroup {
    }
}

