/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.constraints.validatorresolution;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.Size;
import org.hibernate.jsr303.tck.tests.constraints.validatorresolution.Coordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Suburb {
    @Size(min=5, max=10)
    private String name;
    @Size(min=2, max=2)
    private Map<Facility, Boolean> facilities;
    @Size(min=2)
    private Set<String> streetNames;
    @Size(min=4, max=1000)
    private Coordinate[] boundingBox;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<Facility, Boolean> getFacilities() {
        return this.facilities;
    }

    public void addFacility(Facility f, Boolean exist) {
        if (this.facilities == null) {
            this.facilities = new HashMap<Facility, Boolean>();
        }
        this.facilities.put(f, exist);
    }

    public Set<String> getStreetNames() {
        return this.streetNames;
    }

    public void addStreetName(String streetName) {
        if (this.streetNames == null) {
            this.streetNames = new HashSet<String>();
        }
        this.streetNames.add(streetName);
    }

    public Coordinate[] getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(Coordinate[] boundingBox) {
        this.boundingBox = boundingBox;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Facility {
        SHOPPING_MALL,
        BUS_TERMINAL;

    }
}

