/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.constraints.validatorresolution;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.UnexpectedTypeException;
import javax.validation.Validator;
import org.hibernate.jsr303.tck.tests.constraints.validatorresolution.Bar;
import org.hibernate.jsr303.tck.tests.constraints.validatorresolution.BaseClass;
import org.hibernate.jsr303.tck.tests.constraints.validatorresolution.Coordinate;
import org.hibernate.jsr303.tck.tests.constraints.validatorresolution.CustomConstraint;
import org.hibernate.jsr303.tck.tests.constraints.validatorresolution.Foo;
import org.hibernate.jsr303.tck.tests.constraints.validatorresolution.MinMax;
import org.hibernate.jsr303.tck.tests.constraints.validatorresolution.SerializableBarSubclass;
import org.hibernate.jsr303.tck.tests.constraints.validatorresolution.SubClassA;
import org.hibernate.jsr303.tck.tests.constraints.validatorresolution.SubClassB;
import org.hibernate.jsr303.tck.tests.constraints.validatorresolution.Suburb;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class ValidatorResolutionTest {
    @Test
    @SpecAssertion(section="3.5.3", id="a")
    public void testTargetTypeIsInterface() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Assert.assertEquals((int)CustomConstraint.ValidatorForCustomInterface.callCounter, (int)0, (String)"The validate method of ValidatorForCustomInterface should not have been called yet.");
        validator.validate((Object)new CustomInterfaceImpl(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForCustomInterface.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForCustomInterface should have been called.");
    }

    @Test
    @SpecAssertion(section="3.5.3", id="a")
    public void testTargetTypeIsClass() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Assert.assertEquals((int)CustomConstraint.ValidatorForCustomClass.callCounter, (int)0, (String)"The validate method of ValidatorForCustomClass should not have been called yet.");
        validator.validate((Object)new CustomClass(), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForCustomClass.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForCustomClass should have been called.");
    }

    @Test
    @SpecAssertion(section="3.5.3", id="b")
    public void testTargetedTypeIsField() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassA.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassA should not have been called yet.");
        validator.validate((Object)new SubClassAHolder(new SubClassA()), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassA.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassA should have been called.");
    }

    @Test
    @SpecAssertion(section="3.5.3", id="c")
    public void testTargetedTypeIsGetter() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Assert.assertEquals((int)CustomConstraint.ValidatorForSubClassB.callCounter, (int)0, (String)"The validate method of ValidatorForSubClassB should not have been called yet.");
        validator.validate((Object)new SubClassBHolder(new SubClassB()), new Class[0]);
        Assert.assertTrue((CustomConstraint.ValidatorForSubClassB.callCounter > 0 ? 1 : 0) != 0, (String)"The validate method of ValidatorForSubClassB should have been called.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.5.3", id="d")})
    public void testResolutionOfMultipleSizeValidators() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Suburb suburb = new Suburb();
        Set constraintViolations = validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        suburb.setName("");
        constraintViolations = validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), Suburb.class, "", "name");
        suburb.setName("Hoegsbo");
        constraintViolations = validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        suburb.addFacility(Suburb.Facility.SHOPPING_MALL, false);
        constraintViolations = validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), Suburb.class, suburb.getFacilities(), "facilities");
        suburb.addFacility(Suburb.Facility.BUS_TERMINAL, true);
        constraintViolations = validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        suburb.addStreetName("Sikelsgatan");
        constraintViolations = validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), Suburb.class, suburb.getStreetNames(), "streetNames");
        suburb.addStreetName("Marklandsgatan");
        constraintViolations = validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        Coordinate[] boundingBox = new Coordinate[]{new Coordinate(0L, 0L), new Coordinate(0L, 1L), new Coordinate(1L, 0L)};
        suburb.setBoundingBox(boundingBox);
        constraintViolations = validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), Suburb.class, suburb.getBoundingBox(), "boundingBox");
        boundingBox = new Coordinate[]{new Coordinate(0L, 0L), new Coordinate(0L, 1L), new Coordinate(1L, 0L), new Coordinate(1L, 1L)};
        suburb.setBoundingBox(boundingBox);
        constraintViolations = validator.validate((Object)suburb, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.5.3", id="d")})
    public void testResolutionOfMinMaxForDifferentTypes() {
        Validator validator = TestUtil.getValidatorUnderTest();
        MinMax minMax = new MinMax("5", 5);
        Set constraintViolations = validator.validate((Object)minMax, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "number", "numberAsString");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.5.3", id="e"), @SpecAssertion(section="2.1", id="d"), @SpecAssertion(section="2.4", id="i")})
    public void testUnexpectedTypeInValidatorResolution() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Bar bar = new Bar();
        try {
            validator.validate((Object)bar, new Class[0]);
            Assert.fail();
        }
        catch (UnexpectedTypeException unexpectedTypeException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.5.3", id="f"), @SpecAssertion(section="8.3", id="b")})
    public void testAmbiguousValidatorResolution() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Foo foo = new Foo(new SerializableBarSubclass());
        try {
            validator.validate((Object)foo, new Class[0]);
            Assert.fail((String)"The test should have failed due to ambiguous validator resolution.");
        }
        catch (UnexpectedTypeException unexpectedTypeException) {
            // empty catch block
        }
    }

    public class CustomInterfaceImpl
    implements CustomInterface {
    }

    @CustomConstraint
    public static interface CustomInterface {
    }

    @CustomConstraint
    public class CustomClass {
    }

    public class SubClassBHolder {
        private BaseClass baseClass;

        public SubClassBHolder(SubClassB subClass) {
            this.baseClass = subClass;
        }

        @CustomConstraint
        public SubClassB getBaseClass() {
            return (SubClassB)this.baseClass;
        }
    }

    public class SubClassAHolder {
        @CustomConstraint
        private SubClassA subClass;

        SubClassAHolder(SubClassA subClass) {
            this.subClass = subClass;
        }

        public BaseClass getSubClass() {
            return this.subClass;
        }
    }
}

