/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.messageinterpolation;

import java.util.Date;
import java.util.Locale;
import java.util.Set;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
@Resources(value={@Resource(source="ValidationMessages.properties", destination="WEB-INF/classes/ValidationMessages.properties"), @Resource(source="ValidationMessages_de.properties", destination="WEB-INF/classes/ValidationMessages_de.properties")})
@IntegrationTest
public class MessageInterpolationTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="4.3.1", id="a")
    public void testDefaultMessageInterpolatorIsNotNull() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        Assert.assertNotNull((Object)interpolator, (String)"Each bean validation provider must provide a default message interpolator.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.3.1", id="e"), @SpecAssertion(section="4.3.1.1", id="a")})
    public void testSuccessfulInterpolationOfValidationMessagesValue() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "replacement worked";
        String actual = interpolator.interpolate("{foo}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "replacement worked replacement worked";
        actual = interpolator.interpolate("{foo} {foo}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "This replacement worked just fine";
        actual = interpolator.interpolate("This {foo} just fine", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "{} replacement worked {unknown}";
        actual = interpolator.interpolate("{} {foo} {unknown}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="4.3.1.1", id="b")
    public void testRecursiveMessageInterpolation() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "fubar");
        TestContext context = new TestContext(descriptor);
        String expected = "recursion worked";
        String actual = interpolator.interpolate((String)descriptor.getAttributes().get("message"), (MessageInterpolator.Context)context);
        Assert.assertEquals((String)expected, (String)actual, (String)"Expansion should be recursive");
    }

    @Test
    @SpecAssertion(section="4.3.1", id="d")
    public void testMessagesCanBeOverriddenAtConstraintLevel() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateProperty((Object)new DummyEntity(), "snafu", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "messages can also be overridden at constraint declaration.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.3.1", id="f"), @SpecAssertion(section="4.3.1", id="g"), @SpecAssertion(section="4.3.1", id="h")})
    public void testLiteralCurlyBraces() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "{";
        String actual = interpolator.interpolate("\\{", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "}";
        actual = interpolator.interpolate("\\}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "\\";
        actual = interpolator.interpolate("\\", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="4.3.1.1", id="a")
    public void testUnSuccessfulInterpolation() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "foo";
        String actual = interpolator.interpolate("foo", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
        expected = "#{foo  {}";
        actual = interpolator.interpolate("#{foo  {}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="4.3.1.1", id="a")
    public void testUnknownTokenInterpolation() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "{bar}";
        String actual = interpolator.interpolate("{bar}", (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="4.3.1.1", id="c")
    public void testParametersAreExtractedFromBeanValidationProviderBundle() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(Person.class, "birthday");
        TestContext context = new TestContext(descriptor);
        String key = "{javax.validation.constraints.Past.message}";
        String actual = interpolator.interpolate(key, (MessageInterpolator.Context)context);
        Assert.assertFalse((boolean)key.equals(actual), (String)"There should have been a message interpolation from the bean validator provider bundle.");
    }

    @Test
    @SpecAssertion(section="4.3.1.1", id="g")
    public void testConstraintAttributeValuesAreInterpolated() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "bar");
        TestContext context = new TestContext(descriptor);
        String expected = "size must be between 5 and 10";
        String actual = interpolator.interpolate((String)descriptor.getAttributes().get("message"), (MessageInterpolator.Context)context);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="4.3.1.1", id="h")
    public void testMessageInterpolationWithLocale() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        TestContext context = new TestContext(descriptor);
        String expected = "kann nicht null sein";
        String actual = interpolator.interpolate((String)descriptor.getAttributes().get("message"), (MessageInterpolator.Context)context, Locale.GERMAN);
        Assert.assertEquals((String)actual, (String)expected, (String)"Wrong substitution");
    }

    @Test
    @SpecAssertion(section="4.3.1.1", id="i")
    public void testIfNoLocaleIsSpecifiedTheDefaultLocaleIsAssumed() {
        MessageInterpolator interpolator = TestUtil.getDefaultMessageInterpolator();
        ConstraintDescriptor<?> descriptor = this.getDescriptorFor(DummyEntity.class, "foo");
        String messageTemplate = (String)descriptor.getAttributes().get("message");
        TestContext context = new TestContext(descriptor);
        String messageInterpolatedWithNoLocale = interpolator.interpolate(messageTemplate, (MessageInterpolator.Context)context);
        String messageInterpolatedWithDefaultLocale = interpolator.interpolate(messageTemplate, (MessageInterpolator.Context)context, Locale.getDefault());
        Assert.assertEquals((String)messageInterpolatedWithNoLocale, (String)messageInterpolatedWithDefaultLocale, (String)"Wrong substitution");
    }

    private ConstraintDescriptor<?> getDescriptorFor(Class<?> clazz, String propertyName) {
        Validator validator = TestUtil.getValidatorUnderTest();
        return (ConstraintDescriptor)validator.getConstraintsForClass(clazz).getConstraintsForProperty(propertyName).getConstraintDescriptors().iterator().next();
    }

    public class Person {
        String name;
        @Past
        Date birthday;
    }

    public class DummyEntity {
        @NotNull
        String foo;
        @Size(min=5, max=10, message="size must be between {min} and {max}")
        String bar;
        @Max(value=10L, message="{replace.in.user.bundle1}")
        String fubar;
        @NotNull(message="messages can also be overridden at constraint declaration.")
        String snafu;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestContext
    implements MessageInterpolator.Context {
        ConstraintDescriptor<?> descriptor;

        TestContext(ConstraintDescriptor<?> descriptor) {
            this.descriptor = descriptor;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.descriptor;
        }

        public Object getValidatedValue() {
            return null;
        }
    }
}

