/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.metadata;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.jsr303.tck.tests.metadata.Account;
import org.hibernate.jsr303.tck.tests.metadata.Customer;
import org.hibernate.jsr303.tck.tests.metadata.Man;
import org.hibernate.jsr303.tck.tests.metadata.Order;
import org.hibernate.jsr303.tck.tests.metadata.UnconstraintEntity;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class BeanDescriptorTest
extends AbstractTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1", id="b"), @SpecAssertion(section="5.3", id="a")})
    public void testIsBeanConstrainedDueToValidAnnotation() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Customer.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to @valid ");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1", id="b"), @SpecAssertion(section="5.3", id="a")})
    public void testIsBeanConstrainedDueToConstraintOnEntity() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Account.class);
        Assert.assertTrue((boolean)beanDescriptor.hasConstraints(), (String)"There should be direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to @valid");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1", id="b"), @SpecAssertion(section="5.3", id="a")})
    public void testIsBeanConstrainedDueToConstraintProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Order.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to @NotNull");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1", id="b"), @SpecAssertion(section="5.3", id="a")})
    public void testIsBeanConstrainedDueToConstraintOnInterface() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Man.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be constrained due to constraints on Person.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1", id="b"), @SpecAssertion(section="5.3", id="a")})
    public void testUnconstrainedClass() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(UnconstraintEntity.class);
        Assert.assertFalse((boolean)beanDescriptor.hasConstraints(), (String)"There should be no direct constraints on the specified bean.");
        Assert.assertFalse((boolean)beanDescriptor.isBeanConstrained(), (String)"Bean should be unconstrained.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1", id="b"), @SpecAssertion(section="5.3", id="b")})
    public void testGetConstraintForConstrainedProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Order.class);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty("orderNumber");
        Assert.assertEquals((int)propertyDescriptor.getConstraintDescriptors().size(), (int)1, (String)"There should be one constraint descriptor");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.3", id="b"), @SpecAssertion(section="5.3", id="b"), @SpecAssertion(section="5.4", id="a")})
    public void testGetConstraintForUnConstrainedProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Customer.class);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty("orderList");
        Assert.assertEquals((int)propertyDescriptor.getConstraintDescriptors().size(), (int)0, (String)"There should be no constraint descriptors");
        Assert.assertTrue((boolean)propertyDescriptor.isCascaded(), (String)"The property should be cascaded");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1", id="b"), @SpecAssertion(section="5.3", id="b")})
    public void testGetConstraintsForNonExistingProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Order.class);
        Assert.assertNull((Object)beanDescriptor.getConstraintsForProperty("foobar"), (String)"There should be no descriptor");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1", id="b"), @SpecAssertion(section="5.3", id="b")})
    public void testGetConstrainedProperties() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Order.class);
        Set constraintProperties = beanDescriptor.getConstrainedProperties();
        Assert.assertEquals((int)constraintProperties.size(), (int)1, (String)"There should be only one property");
        boolean hasOrderNumber = false;
        for (PropertyDescriptor pd : constraintProperties) {
            hasOrderNumber |= pd.getPropertyName().equals("orderNumber");
        }
        Assert.assertTrue((boolean)hasOrderNumber, (String)"Wrong property");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1", id="b"), @SpecAssertion(section="5.3", id="b")})
    public void testGetConstrainedPropertiesForUnconstrainedEntity() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(UnconstraintEntity.class);
        Set constraintProperties = beanDescriptor.getConstrainedProperties();
        Assert.assertEquals((int)constraintProperties.size(), (int)0, (String)"We should get the empty set.");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.3", id="c")
    public void testGetConstraintsForNullProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Order.class);
        beanDescriptor.getConstraintsForProperty(null);
    }
}

