/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.metadata;

import java.lang.annotation.ElementType;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import javax.validation.metadata.Scope;
import org.hibernate.jsr303.tck.tests.metadata.SubClass;
import org.hibernate.jsr303.tck.tests.metadata.SuperClass;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class ElementDescriptorTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="5.2", id="a")
    public void testGetElementClass() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SuperClass.class);
        Assert.assertEquals((Object)beanDescriptor.getElementClass(), SuperClass.class, (String)"Wrong element class");
        PropertyDescriptor elementDescriptor = beanDescriptor.getConstraintsForProperty("myField");
        Assert.assertEquals((Object)elementDescriptor.getElementClass(), String.class, (String)"Wrong element class");
    }

    @Test
    @SpecAssertion(section="5.2", id="b")
    public void testGetConstraintDescriptors() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(SubClass.class, "myField");
        Assert.assertEquals((int)descriptor.getConstraintDescriptors().size(), (int)2, (String)"There should be two constraints on myField");
    }

    @Test
    @SpecAssertion(section="5.2", id="c")
    public void testHasConstraints() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(SubClass.class, "myField");
        AssertJUnit.assertTrue((boolean)descriptor.hasConstraints());
    }

    @Test
    @SpecAssertion(section="5.2", id="d")
    public void testUnorderedAndMatchingGroups() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SubClass.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Set descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().unorderedAndMatchingGroups(new Class[]{Default.class, SuperClass.BasicGroup.class}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 2 ? 1 : 0) != 0);
        descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().unorderedAndMatchingGroups(new Class[]{SuperClass.UnusedGroup.class}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertion(section="5.2", id="d")
    public void testUnorderedAndMatchingGroupsWithInheritance() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SubClass.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Set descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().unorderedAndMatchingGroups(new Class[]{SuperClass.InheritedGroup.class}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertion(section="5.2", id="d")
    public void testUnorderedAndMatchingGroupsWithDefaultGroupOverriding() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SubClass.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Set descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().unorderedAndMatchingGroups(new Class[]{Default.class}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertion(section="5.2", id="e")
    public void testDeclaredOn() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SubClass.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Set descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().lookingAt(Scope.HIERARCHY).declaredOn(new ElementType[]{ElementType.TYPE}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 0 ? 1 : 0) != 0);
        descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().lookingAt(Scope.HIERARCHY).declaredOn(new ElementType[]{ElementType.METHOD}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 0 ? 1 : 0) != 0);
        descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().lookingAt(Scope.HIERARCHY).declaredOn(new ElementType[]{ElementType.FIELD}).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertion(section="5.2", id="f")
    public void testLookingAt() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(SubClass.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Set descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().lookingAt(Scope.HIERARCHY).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 2 ? 1 : 0) != 0);
        descriptors = beanDescriptor.getConstraintsForProperty("myField").findConstraints().lookingAt(Scope.LOCAL_ELEMENT).getConstraintDescriptors();
        AssertJUnit.assertTrue((descriptors.size() == 1 ? 1 : 0) != 0);
    }
}

