/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.metadata;

import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.jsr303.tck.tests.metadata.Customer;
import org.hibernate.jsr303.tck.tests.metadata.Order;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class PropertyDescriptorTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="5.4", id="a")
    public void testIsNotCascaded() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Order.class, "orderNumber");
        Assert.assertFalse((boolean)descriptor.isCascaded(), (String)"Should not be cascaded");
    }

    @Test
    @SpecAssertion(section="5.4", id="a")
    public void testIsCascaded() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, "orderList");
        Assert.assertTrue((boolean)descriptor.isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertion(section="5.4", id="b")
    public void testPropertyName() {
        String propertyName = "orderList";
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, propertyName);
        Assert.assertEquals((String)descriptor.getPropertyName(), (String)propertyName, (String)"Wrong property name");
    }
}

