/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.traversableresolver;

import java.lang.annotation.ElementType;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.jsr303.tck.tests.traversableresolver.ExceptionThrowingTraversableResolver;
import org.hibernate.jsr303.tck.tests.traversableresolver.Jacket;
import org.hibernate.jsr303.tck.tests.traversableresolver.Person;
import org.hibernate.jsr303.tck.tests.traversableresolver.SnifferTraversableResolver;
import org.hibernate.jsr303.tck.tests.traversableresolver.Suit;
import org.hibernate.jsr303.tck.tests.traversableresolver.Trousers;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class TraversableResolverTest
extends AbstractTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.5.2", id="a"), @SpecAssertion(section="3.5.2", id="b"), @SpecAssertion(section="3.5.2", id="c")})
    public void testCorrectNumberOfCallsToIsReachableAndIsCascadable() {
        Suit suit = new Suit();
        suit.setTrousers(new Trousers());
        suit.setJacket(new Jacket());
        suit.setSize(3333);
        suit.getTrousers().setLength(32321);
        suit.getJacket().setWidth(432432);
        SnifferTraversableResolver resolver = new SnifferTraversableResolver(suit);
        Configuration config = TestUtil.getConfigurationUnderTest().traversableResolver((TraversableResolver)resolver);
        ValidatorFactory factory = config.buildValidatorFactory();
        Validator v = factory.getValidator();
        v.validate((Object)suit, new Class[0]);
        Assert.assertEquals((int)resolver.getReachPaths().size(), (int)5);
        Assert.assertEquals((int)resolver.getCascadePaths().size(), (int)2);
    }

    @Test
    @SpecAssertion(section="3.5.2", id="d")
    public void testCustomTraversableResolverViaConfiguration() {
        Configuration<?> configuration = TestUtil.getConfigurationUnderTest();
        configuration.traversableResolver((TraversableResolver)new DummyTraversableResolver());
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Validator validator = factory.getValidator();
        Person person = new Person();
        Set constraintViolations = validator.validate((Object)person, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="3.5.2", id="e")
    public void testResolverExceptionsGetWrappedInValidationException() {
        ExceptionThrowingTraversableResolver resolver = new ExceptionThrowingTraversableResolver();
        Configuration config = TestUtil.getConfigurationUnderTest().traversableResolver((TraversableResolver)resolver);
        ValidatorFactory factory = config.buildValidatorFactory();
        Validator v = factory.getValidator();
        v.validate((Object)new Suit(), new Class[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyTraversableResolver
    implements TraversableResolver {
        private DummyTraversableResolver() {
        }

        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return false;
        }

        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return false;
        }
    }
}

