/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Payload;
import javax.validation.Valid;
import javax.validation.Validator;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.tests.validation.Actor;
import org.hibernate.jsr303.tck.tests.validation.ActorArrayBased;
import org.hibernate.jsr303.tck.tests.validation.ActorListBased;
import org.hibernate.jsr303.tck.tests.validation.Customer;
import org.hibernate.jsr303.tck.tests.validation.Engine;
import org.hibernate.jsr303.tck.tests.validation.Order;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidationProvider.DummyValidatorFactory.class, TCKValidatorConfiguration.class})
public class PropertyPathTest
extends AbstractTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="g"), @SpecAssertion(section="4.2", id="m")})
    public void testPropertyPathWithConstraintViolationForRootObject() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)new VerySpecialClass(), new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), null);
        Assert.assertFalse((boolean)node.isInIterable());
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="h"), @SpecAssertion(section="4.2", id="l")})
    public void testPropertyPathTraversedObject() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Engine engine = new Engine();
        engine.setSerialNumber("ABCDEFGH1234");
        Set constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"serialNumber");
        Assert.assertFalse((boolean)node.isInIterable());
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="i"), @SpecAssertion(section="4.2", id="k")})
    public void testPropertyPathWithList() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorListBased clint = new ActorListBased("Clint", "Eastwood");
        ActorListBased morgan = new ActorListBased("Morgan", null);
        ActorListBased charlie = new ActorListBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        Set constraintViolations = validator.validate((Object)clint, new Class[0]);
        this.checkActorViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="i"), @SpecAssertion(section="4.2", id="k")})
    public void testPropertyPathWithArray() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorArrayBased clint = new ActorArrayBased("Clint", "Eastwood");
        ActorArrayBased morgan = new ActorArrayBased("Morgan", null);
        ActorArrayBased charlie = new ActorArrayBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        Set constraintViolations = validator.validate((Object)clint, new Class[0]);
        this.checkActorViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="j"), @SpecAssertion(section="4.2", id="k")})
    public void testPropertyPathWithMap() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorDB db = new ActorDB();
        ActorArrayBased morgan = new ActorArrayBased("Morgan", null);
        Integer id = db.addActor(morgan);
        Set constraintViolations = validator.validate((Object)db, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"actors");
        Assert.assertEquals((Object)node.getKey(), (Object)id);
        Assert.assertTrue((boolean)node.isInIterable());
        node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"lastName");
        Assert.assertFalse((boolean)node.isInIterable());
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="k")})
    public void testPropertyPathSet() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        customer.setFirstName("John");
        customer.setLastName("Doe");
        Order order = new Order();
        customer.addOrder(order);
        Set constraintViolations = validator.validate((Object)customer, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"orders");
        Assert.assertTrue((boolean)node.isInIterable());
        node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"orderNumber");
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    private void checkActorViolations(Set<ConstraintViolation<Actor>> constraintViolations) {
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"playedWith");
        Assert.assertEquals((Object)node.getIndex(), (Object)new Integer(0));
        Assert.assertTrue((boolean)node.isInIterable());
        node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"playedWith");
        Assert.assertEquals((Object)node.getIndex(), (Object)new Integer(1));
        Assert.assertTrue((boolean)node.isInIterable());
        node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"lastName");
        Assert.assertFalse((boolean)node.isInIterable());
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    class ActorDB {
        private int idGen = 0;
        @Valid
        Map<Integer, Actor> actors = new HashMap<Integer, Actor>();

        ActorDB() {
        }

        public Integer addActor(Actor actor) {
            Integer id = this.idGen++;
            this.actors.put(id, actor);
            return id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpecialValidator
    implements ConstraintValidator<Special, VerySpecialClass> {
        public void initialize(Special constraintAnnotation) {
        }

        public boolean isValid(VerySpecialClass clazz, ConstraintValidatorContext constraintValidatorContext) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Constraint(validatedBy={SpecialValidator.class})
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Special {
        public String message() default "special validation failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    @Special
    class VerySpecialClass {
        VerySpecialClass() {
        }
    }
}

