/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.validation;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.constraints.Size;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.tests.validation.Address;
import org.hibernate.jsr303.tck.tests.validation.BadlyBehavedEntity;
import org.hibernate.jsr303.tck.tests.validation.Customer;
import org.hibernate.jsr303.tck.tests.validation.Order;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidationProvider.DummyValidatorFactory.class, TCKValidatorConfiguration.class})
public class ValidatePropertyTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="4.1.1", id="e")
    public void testPassingNullAsGroup() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        try {
            validator.validateProperty((Object)customer, "firstName", null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="4.1.1", id="e")
    public void testIllegalArgumentExceptionIsThrownForNullValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        try {
            validator.validateProperty(null, "firstName", new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.1.1", id="e"), @SpecAssertion(section="4.1.1", id="f")})
    public void testValidatePropertyWithInvalidPropertyPath() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        try {
            validator.validateProperty((Object)customer, "foobar", new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            validator.validateProperty((Object)customer, "FirstName", new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="4.1.1", id="e")
    public void testValidatePropertyWithNullProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        try {
            validator.validateProperty((Object)customer, null, new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="4.1.1", id="e")
    public void testValidatePropertyWithEmptyProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        Order order = new Order();
        customer.addOrder(order);
        try {
            validator.validateProperty((Object)customer, "", new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.1.1", id="c"), @SpecAssertion(section="4.1.1", id="d"), @SpecAssertion(section="4.1.1", id="f")})
    public void testValidateProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Address address = new Address();
        address.setStreet(null);
        address.setZipCode(null);
        String townInNorthWales = "Llanfairpwllgwyngyllgogerychwyrndrobwyll-llantysiliogogogoch";
        address.setCity(townInNorthWales);
        Set constraintViolations = validator.validateProperty((Object)address, "city", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, Size.class);
        ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
        TestUtil.assertConstraintViolation(violation, Address.class, townInNorthWales, "city");
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "City name cannot be longer than 30 characters.");
        address.setCity("London");
        constraintViolations = validator.validateProperty((Object)address, "city", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="4.1.1", id="g")
    public void testValidIsNotHonoredValidateProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        Order order = new Order();
        customer.addOrder(order);
        Set constraintViolations = validator.validateProperty((Object)customer, "orders", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="4.1.1", id="k")
    public void testUnexpectedExceptionsInValidatePropertyGetWrappedInValidationExceptions() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validateProperty((Object)new BadlyBehavedEntity(), "value", new Class[0]);
    }
}

