/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.validation;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.tests.validation.ActorArrayBased;
import org.hibernate.jsr303.tck.tests.validation.ActorListBased;
import org.hibernate.jsr303.tck.tests.validation.Address;
import org.hibernate.jsr303.tck.tests.validation.BadlyBehavedEntity;
import org.hibernate.jsr303.tck.tests.validation.Boy;
import org.hibernate.jsr303.tck.tests.validation.Customer;
import org.hibernate.jsr303.tck.tests.validation.Engine;
import org.hibernate.jsr303.tck.tests.validation.Last;
import org.hibernate.jsr303.tck.tests.validation.NotEmpty;
import org.hibernate.jsr303.tck.tests.validation.Order;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidationProvider.DummyValidatorFactory.class, TCKValidatorConfiguration.class})
public class ValidateTest
extends AbstractTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="a"), @SpecAssertion(section="3.1.2", id="f"), @SpecAssertion(section="5.1", id="a")})
    public void testValidatedPropertyDoesNotFollowJavaBeansConvention() {
        try {
            Boy boy = new Boy();
            TestUtil.getValidatorUnderTest().validate((Object)boy, new Class[0]);
            Assert.fail();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="5.1", id="b")
    public void testConstraintDescriptorWithoutExplicitGroup() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Order.class);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty("orderNumber");
        Set descriptors = propertyDescriptor.getConstraintDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)1, (String)"There should be only one constraint descriptor");
        ConstraintDescriptor descriptor = (ConstraintDescriptor)descriptors.iterator().next();
        Set groups = descriptor.getGroups();
        Assert.assertTrue((groups.size() == 1 ? 1 : 0) != 0, (String)"There should be only one group");
        Assert.assertEquals(groups.iterator().next(), Default.class, (String)"The declared constraint does not explicitly define a group, hence Default is expected");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1", id="c")
    public void testNullParameterToGetConstraintsForClass() {
        TestUtil.getValidatorUnderTest().getConstraintsForClass(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="4.1.1", id="b")
    public void testValidateWithNullValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate(null, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="4.1.1", id="b")
    public void testValidateWithNullGroup() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new Boy(), null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.1.1", id="a"), @SpecAssertion(section="4.1.1", id="c")})
    public void testMultipleViolationOfTheSameType() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Engine engine = new Engine();
        engine.setSerialNumber("mail@foobar.com");
        Set constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        engine.setSerialNumber("ABCDEFGH1234");
        constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        engine.setSerialNumber("ABCD-EFGH-1234");
        constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="4.1.1", id="c")
    public void testMultipleConstraintViolationOfDifferentTypes() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Address address = new Address();
        address.setStreet(null);
        address.setZipCode(null);
        address.setCity("Llanfairpwllgwyngyllgogerychwyrndrobwyll-llantysiliogogogoch");
        Set constraintViolations = validator.validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, Size.class, NotEmpty.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="a"), @SpecAssertion(section="4.2", id="a"), @SpecAssertion(section="4.2", id="b"), @SpecAssertion(section="4.2", id="c"), @SpecAssertion(section="4.2", id="d"), @SpecAssertion(section="4.2", id="e")})
    public void testConstraintViolation() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Engine engine = new Engine();
        engine.setSerialNumber("ABCDEFGH1234");
        Set constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((String)violation.getMessage(), (String)"must match ^....-....-....$", (String)"Wrong message");
        Assert.assertEquals((String)violation.getMessageTemplate(), (String)"must match {regexp}", (String)"Wrong message template");
        Assert.assertEquals((Object)violation.getRootBean(), (Object)engine, (String)"Wrong root entity.");
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)"ABCDEFGH1234", (String)"Wrong validated value");
        Assert.assertNotNull((Object)violation.getConstraintDescriptor(), (String)"Constraint descriptor should not be null");
        Annotation ann = violation.getConstraintDescriptor().getAnnotation();
        Assert.assertEquals(ann.annotationType(), Pattern.class, (String)"Wrong annotation type");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "serialNumber");
        engine.setSerialNumber("ABCD-EFGH-1234");
        constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.4", id="o")})
    public void testGraphValidationWithList() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorListBased clint = new ActorListBased("Clint", "Eastwood");
        ActorListBased morgan = new ActorListBased("Morgan", null);
        ActorListBased charlie = new ActorListBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        morgan.addPlayedWith(clint);
        clint.addPlayedWith(morgan);
        Set constraintViolations = validator.validate((Object)clint, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((String)constraintViolation.getMessage(), (String)"Everyone has a last name.", (String)"Wrong message");
        Assert.assertEquals((Object)constraintViolation.getRootBean(), (Object)clint, (String)"Wrong root entity");
        Assert.assertEquals((Object)constraintViolation.getInvalidValue(), (Object)morgan.getLastName(), (String)"Wrong value");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "playedWith[0].playedWith[1].lastName", "playedWith[1].lastName");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.4", id="o"), @SpecAssertion(section="3.1.3", id="c")})
    public void testGraphValidationWithArray() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorArrayBased clint = new ActorArrayBased("Clint", "Eastwood");
        ActorArrayBased morgan = new ActorArrayBased("Morgan", null);
        ActorArrayBased charlie = new ActorArrayBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        morgan.addPlayedWith(clint);
        clint.addPlayedWith(morgan);
        Set constraintViolations = validator.validate((Object)clint, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((String)constraintViolation.getMessage(), (String)"Everyone has a last name.", (String)"Wrong message");
        Assert.assertEquals((Object)constraintViolation.getRootBean(), (Object)clint, (String)"Wrong root entity");
        Assert.assertEquals((Object)constraintViolation.getInvalidValue(), (Object)morgan.getLastName(), (String)"Wrong value");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "playedWith[0].playedWith[1].lastName", "playedWith[1].lastName");
    }

    @Test
    @SpecAssertion(section="4.1.1", id="b")
    public void testPassingNullAsGroup() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        try {
            validator.validate((Object)customer, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="3.5", id="b")
    public void testOnlyFirstGroupInSequenceGetEvaluated() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Car car = new Car("USd-298");
        Set violations = validator.validateProperty((Object)car, "licensePlateNumber", new Class[]{First.class, Second.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        car.setLicensePlateNumber("USD-298");
        violations = validator.validateProperty((Object)car, "licensePlateNumber", new Class[]{First.class, Second.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="4.1.1", id="k")
    public void testUnexpectedExceptionsInValidateGetWrappedInValidationExceptions() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new BadlyBehavedEntity(), new Class[0]);
    }

    @Test
    public void testValidationIsPolymorphic() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        customer.setFirstName("Foo");
        customer.setLastName("Bar");
        Order order = new Order();
        customer.addOrder(order);
        Set constraintViolations = validator.validate((Object)customer, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), Customer.class, null, "orders[].orderNumber");
        order.setOrderNumber(123);
        constraintViolations = validator.validate((Object)customer, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    public void testObjectTraversion() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        customer.setFirstName("John");
        customer.setLastName("Doe");
        for (int i = 0; i < 100; ++i) {
            Order order = new Order();
            customer.addOrder(order);
        }
        Set constraintViolations = validator.validate((Object)customer, new Class[]{Default.class, First.class, Second.class, Last.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 100);
    }

    static interface Second {
    }

    static interface First {
    }

    class Car {
        @Pattern(regexp="[A-Z][A-Z][A-Z]-[0-9][0-9][0-9]", groups={First.class, Second.class})
        private String licensePlateNumber;

        Car(String licensePlateNumber) {
            this.licensePlateNumber = licensePlateNumber;
        }

        public String getLicensePlateNumber() {
            return this.licensePlateNumber;
        }

        public void setLicensePlateNumber(String licensePlateNumber) {
            this.licensePlateNumber = licensePlateNumber;
        }
    }
}

