/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.validation;

import java.util.ArrayList;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.tests.validation.Address;
import org.hibernate.jsr303.tck.tests.validation.Customer;
import org.hibernate.jsr303.tck.tests.validation.Order;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidationProvider.DummyValidatorFactory.class, TCKValidatorConfiguration.class})
public class ValidateValueTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="4.1.1", id="h")
    public void testValidateValueSuccess() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateValue(Address.class, "city", (Object)"Paris", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="4.1.1", id="h")
    public void testValidateValueFailure() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateValue(Address.class, "city", null, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "You have to specify a city.");
    }

    @Test
    @SpecAssertion(section="4.1.1", id="h")
    public void testValidateValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateValue(Order.class, "orderNumber", null, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "orderNumber");
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "An order must have an order number.");
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        TestUtil.assertConstraintViolation(constraintViolation, Order.class, null, "orderNumber");
        Assert.assertEquals((Object)constraintViolation.getRootBeanClass(), Order.class, (String)"Wrong root bean class");
        constraintViolations = validator.validateValue(Order.class, "orderNumber", (Object)1234, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="4.1.1", id="i")
    public void testValidateValueWithInvalidPropertyPath() {
        Validator validator = TestUtil.getValidatorUnderTest();
        try {
            validator.validateValue(Customer.class, "foobar", null, new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            validator.validateValue(Customer.class, "FirstName", null, new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="4.1.1", id="i")
    public void testExistingPropertyWoConstraintsNorCascaded() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validateValue(Customer.class, "middleName", new ArrayList(), new Class[0]);
    }

    @Test
    @SpecAssertion(section="4.1.1", id="i")
    public void testValidateValuePassingNullAsGroup() {
        Validator validator = TestUtil.getValidatorUnderTest();
        try {
            validator.validateValue(Customer.class, "firstName", (Object)"foobar", null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="4.1.1", id="i")
    public void testValidateValueWithEmptyPropertyPath() {
        Validator validator = TestUtil.getValidatorUnderTest();
        try {
            validator.validateValue(Customer.class, "", null, new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="4.1.1", id="i")
    public void testValidateValueWithNullObject() {
        Validator validator = TestUtil.getValidatorUnderTest();
        try {
            validator.validateValue(null, "firstName", (Object)"foobar", new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="4.1.1", id="i")
    public void testValidateValueWithNullPropertyName() {
        Validator validator = TestUtil.getValidatorUnderTest();
        try {
            validator.validateValue(Customer.class, null, (Object)"foobar", new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertion(section="4.1.1", id="j")
    public void testValidIsNotHonoredValidateValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        Order order = new Order();
        customer.addOrder(order);
        Set constraintViolations = validator.validateValue(Customer.class, "orders", (Object)order, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }
}

