/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.validation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.GenericBootstrap;
import javax.validation.bootstrap.ProviderSpecificBootstrap;
import javax.validation.spi.ValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidationProvider.DummyValidatorFactory.class, TCKValidatorConfiguration.class})
public class ValidationTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="4.4.5", id="a")
    public void testBuildDefaultValidatorFactory() {
        ValidatorFactory defaultFactory = Validation.buildDefaultValidatorFactory();
        Assert.assertNotNull((Object)defaultFactory, (String)"We should be able to get a factory.");
        ValidatorFactory defaultProviderFactory = Validation.byDefaultProvider().configure().buildValidatorFactory();
        Assert.assertNotNull((Object)defaultProviderFactory, (String)"We should be able to get a factory.");
        Assert.assertEquals(defaultFactory.getClass(), defaultFactory.getClass(), (String)"The factories have to be identical.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.5", id="b"), @SpecAssertion(section="4.4.5", id="e")})
    public void testCustomValidationProviderResolution() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                ArrayList list = new ArrayList();
                list.add(new TCKValidationProvider());
                return list;
            }
        };
        GenericBootstrap bootstrap = Validation.byDefaultProvider();
        Configuration config = bootstrap.providerResolver(resolver).configure();
        ValidatorFactory factory = config.buildValidatorFactory();
        Assert.assertTrue((boolean)(factory instanceof TCKValidationProvider.DummyValidatorFactory));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.5", id="c"), @SpecAssertion(section="4.4.5", id="e")})
    public void testSpecificValidationProvider() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                ArrayList list = new ArrayList();
                list.add(new TCKValidationProvider());
                return list;
            }
        };
        ProviderSpecificBootstrap bootstrap = Validation.byProvider(TCKValidationProvider.class);
        Configuration config = bootstrap.providerResolver(resolver).configure();
        ValidatorFactory factory = config.buildValidatorFactory();
        Assert.assertTrue((boolean)(factory instanceof TCKValidationProvider.DummyValidatorFactory));
    }

    @Test
    @SpecAssertion(section="4.4.5", id="d")
    public void testVerifyMethodsOfValidationObjects() {
        Field[] validationFields;
        Method[] validationMethods;
        Class<Validation> validatorClass = Validation.class;
        ArrayList<Method> expectedValidationMethods = new ArrayList<Method>();
        Method buildDefaultValidatorFactoryMethod = null;
        try {
            buildDefaultValidatorFactoryMethod = validatorClass.getMethod("buildDefaultValidatorFactory", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)"Validation class is missing bootstrap method.");
        }
        expectedValidationMethods.add(buildDefaultValidatorFactoryMethod);
        Method byDefaultProviderMethod = null;
        try {
            byDefaultProviderMethod = validatorClass.getMethod("byDefaultProvider", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)"Validation class is missing bootstrap method.");
        }
        expectedValidationMethods.add(byDefaultProviderMethod);
        Method byProviderMethod = null;
        try {
            byProviderMethod = validatorClass.getMethod("byProvider", Class.class);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)"Validation class is missing bootstrap method.");
        }
        expectedValidationMethods.add(byProviderMethod);
        for (Method m : validationMethods = validatorClass.getMethods()) {
            if (expectedValidationMethods.contains(m) || m.getDeclaringClass() != validatorClass || !Modifier.isPublic(m.getModifiers()) && !Modifier.isProtected(m.getModifiers())) continue;
            Assert.fail((String)("Validation cannot have a non private method on top of the specified ones. " + m.getName() + " not allowed."));
        }
        for (Field f : validationFields = validatorClass.getFields()) {
            if (f.getDeclaringClass() != validatorClass || !Modifier.isPublic(f.getModifiers()) && !Modifier.isProtected(f.getModifiers())) continue;
            Assert.fail((String)("Validation cannot have a non private field. " + f.getName() + " not allowed."));
        }
    }
}

