/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.validatorfactory;

import javax.validation.Configuration;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.hibernate.jsr303.tck.tests.validatorfactory.MyConstraint;
import org.hibernate.jsr303.tck.tests.validatorfactory.MyConstraintValidator;
import org.hibernate.jsr303.tck.tests.validatorfactory.MySecondConstraint;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class CustomConstraintValidatorTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="2.5", id="a")
    public void testDefaultConstructorInValidatorCalled() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new Dummy(), new Class[0]);
        Assert.assertTrue((boolean)MyConstraintValidator.defaultConstructorCalled, (String)"The no-arg default constructor should have been called.");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="2.5", id="b")
    public void testRuntimeExceptionInValidatorCreationIsWrapped() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new SecondDummy(), new Class[0]);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="2.5", id="c")
    public void testValidationExceptionIsThrownInCaseFactoryReturnsNull() {
        Configuration config = TestUtil.getConfigurationUnderTest().constraintValidatorFactory(new ConstraintValidatorFactory(){

            public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
                return null;
            }
        });
        Validator validator = config.buildValidatorFactory().getValidator();
        validator.validate((Object)new SecondDummy(), new Class[0]);
    }

    public static class SecondDummy {
        @MySecondConstraint
        public int value;
    }

    public static class Dummy {
        @MyConstraint
        public int value;
    }
}

