/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.xmlconfiguration;

import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.ConfigurationDefinedConstraintValidatorFactoryResolver;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.User;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.XmlDefinedConstraintValidatorFactory;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.jsr303.ValidationXml;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidatorConfiguration.class, TCKValidationProvider.DummyValidatorFactory.class})
@ValidationXml(value="validation-ConstraintValidatorFactorySpecifiedInValidationXmlTest.xml")
public class ConstraintValidatorFactorySpecifiedInValidationXmlTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="4.4.6", id="i")
    public void testConstraintValidatorFactorySpecifiedInValidationXml() {
        try {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new User(), new Class[0]);
        }
        catch (ValidationException e) {
            Assert.assertTrue((XmlDefinedConstraintValidatorFactory.numberOfIsReachableCalls > 0 ? 1 : 0) != 0, (String)"The factory should have been called at least once if it was properly picked up by xml configuration.");
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.6", id="i"), @SpecAssertion(section="4.4.6", id="h")})
    public void testConstraintValidatorFactorySpecifiedInValidationXmlCanBeOverridden() {
        try {
            Configuration configuration = Validation.byDefaultProvider().configure();
            configuration = configuration.constraintValidatorFactory((ConstraintValidatorFactory)new ConfigurationDefinedConstraintValidatorFactoryResolver());
            Validator validator = configuration.buildValidatorFactory().getValidator();
            validator.validate((Object)new User(), new Class[0]);
        }
        catch (ValidationException e) {
            Assert.assertTrue((ConfigurationDefinedConstraintValidatorFactoryResolver.numberOfIsReachableCalls > 0 ? 1 : 0) != 0, (String)"The factory  should have been called at least once if configuration settings were applied.");
        }
    }
}

