/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.xmlconfiguration;

import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.constraints.Pattern;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.ConsistentUserInformation;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.User;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidatorConfiguration.class, TCKValidationProvider.DummyValidatorFactory.class})
@Resources(value={@Resource(source="user-constraints.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/user-constraints.xml"), @Resource(source="user-constraints-MultipleBeanDefinitionTest.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/user-constraints-MultipleBeanDefinitionTest.xml"), @Resource(source="user-constraints-MultipleFieldDefinitionTest.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/user-constraints-MultipleFieldDefinitionTest.xml"), @Resource(source="user-constraints-MultipleGetterDefinitionTest.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/user-constraints-MultipleGetterDefinitionTest.xml")})
public class DuplicateConfigurationTest
extends AbstractTest {
    public static final String packageName = "/org/hibernate/jsr303/tck/tests/xmlconfiguration/";
    public static final String mappingFile1 = "user-constraints.xml";
    public static final String mappingFile2 = "user-constraints-MultipleBeanDefinitionTest.xml";
    public static final String mappingFile3 = "user-constraints-MultipleFieldDefinitionTest.xml";
    public static final String mappingFile4 = "user-constraints-MultipleGetterDefinitionTest.xml";

    @Test
    @SpecAssertion(section="7.1", id="a")
    public void testXmlConfiguredConstraintExposesCorrespondingAnnotationViaMetadata() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/jsr303/tck/tests/xmlconfiguration/user-constraints.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(User.class);
        Set constraintDescriptors = beanDescriptor.getConstraintDescriptors();
        Assert.assertEquals((int)constraintDescriptors.size(), (int)1, (String)"There should be one class level constraint defined in xml");
        ConstraintDescriptor descriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertTrue((boolean)(descriptor.getAnnotation() instanceof ConsistentUserInformation));
        constraintDescriptors = beanDescriptor.getConstraintsForProperty("lastname").getConstraintDescriptors();
        Assert.assertEquals((int)constraintDescriptors.size(), (int)1, (String)"There should be one constraint defined in xml for 'lastname'");
        descriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertTrue((boolean)(descriptor.getAnnotation() instanceof Pattern));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.1", id="b"), @SpecAssertion(section="7.1", id="e")})
    public void testBeanCannotBeDescribedMoreThanOnce() {
        try {
            Configuration<?> config = TestUtil.getConfigurationUnderTest();
            config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/jsr303/tck/tests/xmlconfiguration/user-constraints.xml"));
            config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/jsr303/tck/tests/xmlconfiguration/user-constraints-MultipleBeanDefinitionTest.xml"));
            config.buildValidatorFactory().getValidator();
            Assert.fail((String)"You should not be able to define the same bean multiple times.");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.1", id="c"), @SpecAssertion(section="7.1", id="e")})
    public void testFieldMappingCannotOccurMoreThanOnce() {
        try {
            Configuration<?> config = TestUtil.getConfigurationUnderTest();
            config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/jsr303/tck/tests/xmlconfiguration/user-constraints-MultipleFieldDefinitionTest.xml"));
            config.buildValidatorFactory().getValidator();
            Assert.fail((String)"You should not be able to define multiple field mappings per entity");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.1", id="d"), @SpecAssertion(section="7.1", id="e")})
    public void testGetterMappingCannotOccurMoreThanOnce() {
        try {
            Configuration<?> config = TestUtil.getConfigurationUnderTest();
            config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/jsr303/tck/tests/xmlconfiguration/user-constraints-MultipleGetterDefinitionTest.xml"));
            config.buildValidatorFactory().getValidator();
            Assert.fail((String)"You should not be able to define multiple getter mappings per entity");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

