/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.xmlconfiguration;

import java.util.Set;
import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.ConfigurationDefinedMessageInterpolator;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.User;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.jsr303.ValidationXml;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidatorConfiguration.class, TCKValidationProvider.DummyValidatorFactory.class})
@ValidationXml(value="validation-MessageInterpolatorSpecifiedInValidationXmlTest.xml")
public class MessageInterpolatorSpecifiedInValidationXmlTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="4.4.6", id="g")
    public void testMessageInterpolatorSpecifiedInValidationXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Interpolator defined in xml was used.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.6", id="e"), @SpecAssertion(section="4.4.6", id="g")})
    public void testMessageInterpolatorSpecifiedInValidationXmlCanBeOverridden() {
        Configuration configuration = Validation.byDefaultProvider().configure();
        configuration = configuration.messageInterpolator((MessageInterpolator)new ConfigurationDefinedMessageInterpolator());
        Validator validator = configuration.buildValidatorFactory().getValidator();
        User user = new User();
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Interpolator defined in Configuration was used.");
    }
}

