/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.xmlconfiguration;

import java.util.Set;
import javax.validation.Configuration;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.ConfigurationDefinedTraversableResolver;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.User;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.XmlDefinedTraversableResolver;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.jsr303.ValidationXml;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidatorConfiguration.class, TCKValidationProvider.DummyValidatorFactory.class})
@ValidationXml(value="validation-TraversableResolverSpecifiedInValidationXmlTest.xml")
public class TraversableResolverSpecifiedInValidationXmlTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="4.4.6", id="h")
    public void testTraversableResolverSpecifiedInValidationXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Assert.assertTrue((XmlDefinedTraversableResolver.numberOfIsReachableCalls > 0 ? 1 : 0) != 0, (String)"The resolver should have been called at least once if it was properly picked up by xml configuration.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.6", id="e"), @SpecAssertion(section="4.4.6", id="h")})
    public void testMessageInterpolatorSpecifiedInValidationXmlCanBeOverridden() {
        Configuration configuration = Validation.byDefaultProvider().configure();
        configuration = configuration.traversableResolver((TraversableResolver)new ConfigurationDefinedTraversableResolver());
        Validator validator = configuration.buildValidatorFactory().getValidator();
        User user = new User();
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Assert.assertTrue((ConfigurationDefinedTraversableResolver.numberOfIsReachableCalls > 0 ? 1 : 0) != 0, (String)"The resolver should have been called at least once if configuration settings were applied.");
    }
}

