/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.xmlconfiguration;

import java.io.InputStream;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.ConsistentUserInformation;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.CreditCard;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.Error;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.Order;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.User;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.UserType;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.jboss.testharness.impl.packaging.jsr303.ValidationXml;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidatorConfiguration.class, TCKValidationProvider.DummyValidatorFactory.class})
@ValidationXml(value="validation-XmlConfigurationTest.xml")
@Resources(value={@Resource(source="user-constraints.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/user-constraints.xml"), @Resource(source="order-constraints.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/order-constraints.xml"), @Resource(source="order-constraints-XmlConfigurationTest.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/order-constraints-XmlConfigurationTest.xml")})
public class XmlConfigurationTest
extends AbstractTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.6", id="a"), @SpecAssertion(section="4.4.6", id="l"), @SpecAssertion(section="4.4.6", id="k"), @SpecAssertion(section="7.1.1", id="a"), @SpecAssertion(section="7.1.1", id="b"), @SpecAssertion(section="7.1.2", id="a")})
    public void testClassConstraintDefinedInXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Message from xml");
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Set payloads = constraintViolation.getConstraintDescriptor().getPayload();
        Assert.assertTrue((payloads.size() == 1 ? 1 : 0) != 0, (String)"One one payload class is defined in xml");
        Assert.assertTrue((boolean)Error.class.equals(payloads.iterator().next()));
        user.setConsistent(true);
        constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.6", id="b"), @SpecAssertion(section="4.4.6", id="l"), @SpecAssertion(section="4.4.6", id="k"), @SpecAssertion(section="7.1.1", id="a"), @SpecAssertion(section="7.1.1", id="b"), @SpecAssertion(section="7.1.2", id="a")})
    public void testIgnoreValidationXml() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        Validator validator = config.ignoreXmlConfiguration().buildValidatorFactory().getValidator();
        Order order = new Order();
        Set constraintViolations = validator.validate((Object)order, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.6", id="a"), @SpecAssertion(section="4.4.6", id="l"), @SpecAssertion(section="4.4.6", id="k"), @SpecAssertion(section="7.1.1", id="a"), @SpecAssertion(section="7.1.1", id="b"), @SpecAssertion(section="7.1.2", id="a")})
    public void testPropertyConstraintDefinedInXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        user.setConsistent(true);
        user.setFirstname("Wolfeschlegelsteinhausenbergerdorff");
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Size is limited!");
        user.setFirstname("Wolfgang");
        constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.6", id="a"), @SpecAssertion(section="4.4.6", id="l"), @SpecAssertion(section="4.4.6", id="k"), @SpecAssertion(section="7.1.1", id="a"), @SpecAssertion(section="7.1.1", id="b"), @SpecAssertion(section="7.1.2", id="a")})
    public void testFieldConstraintDefinedInXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        user.setConsistent(true);
        user.setFirstname("Wolfgang");
        user.setLastname("doe");
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Last name has to start with with a capital letter.");
        user.setLastname("Doe");
        constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.6", id="a"), @SpecAssertion(section="4.4.6", id="l"), @SpecAssertion(section="4.4.6", id="k"), @SpecAssertion(section="7.1.1", id="a"), @SpecAssertion(section="7.1.1", id="b"), @SpecAssertion(section="7.1.2", id="a")})
    public void testAnnotationDefinedConstraintApplies() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        user.setConsistent(true);
        user.setPhoneNumber("police");
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "A phone number can only contain numbers, whitespaces and dashes.");
        user.setPhoneNumber("112");
        constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.6", id="a"), @SpecAssertion(section="4.4.6", id="l"), @SpecAssertion(section="4.4.6", id="k"), @SpecAssertion(section="7.1.1", id="a"), @SpecAssertion(section="7.1.1", id="b"), @SpecAssertion(section="7.1.2", id="a")})
    public void testCascadingConfiguredInXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        user.setConsistent(true);
        CreditCard card = new CreditCard();
        card.setNumber("not a number");
        user.setCreditcard(card);
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "Not a credit card number.");
        card.setNumber("1234567890");
        constraintViolations = validator.validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="4.4.6", id="m")
    public void testMappingFilesAddedViaConfigurationGetAddedToXmlConfiguredMappings() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Assert.assertFalse((boolean)validator.getConstraintsForClass(Order.class).isBeanConstrained(), (String)"Without additional mapping Order should be unconstrained");
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(this.getStream("/org/hibernate/jsr303/tck/tests/xmlconfiguration/order-constraints-XmlConfigurationTest.xml"));
        validator = config.buildValidatorFactory().getValidator();
        Assert.assertTrue((boolean)validator.getConstraintsForClass(Order.class).isBeanConstrained(), (String)"With additional mapping Order should be constrained");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.1.1.4", id="c"), @SpecAssertion(section="7.1.1.4", id="d"), @SpecAssertion(section="7.1.1.4", id="e"), @SpecAssertion(section="7.1.1.4", id="f"), @SpecAssertion(section="7.1.1.4", id="g")})
    public void testElementConversionInXmlConfiguredConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(User.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained());
        Set constraintDescriptors = beanDescriptor.getConstraintDescriptors();
        Assert.assertTrue((constraintDescriptors.size() == 1 ? 1 : 0) != 0);
        ConstraintDescriptor descriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        ConsistentUserInformation constraintAnnotation = (ConsistentUserInformation)descriptor.getAnnotation();
        Assert.assertEquals((String)constraintAnnotation.stringParam(), (String)"foobar", (String)"Wrong parameter value");
        Assert.assertEquals(constraintAnnotation.classParam(), String.class, (String)"Wrong parameter value");
        Assert.assertEquals((Object)((Object)constraintAnnotation.userType()), (Object)((Object)UserType.SELLER), (String)"Wrong parameter value");
        Assert.assertEquals((Object[])constraintAnnotation.stringArrayParam(), (Object[])new String[]{"foo", "bar"}, (String)"Wrong parameter value");
        Assert.assertEquals((long)constraintAnnotation.max().value(), (long)10L, (String)"Wrong parameter value. Default should be used");
        Assert.assertEquals((int)constraintAnnotation.patterns().length, (int)2, (String)"Wrong array size");
    }

    private InputStream getStream(String fileName) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
    }
}

