/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.xmlconfiguration.constraintdeclaration;

import java.util.Set;
import javax.validation.Configuration;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.constraintdeclaration.Package;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.jsr303.ValidationXml;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
@ValidationXml(value="validation-ConfigurationViaXmlAndAnnotationsTest.xml")
@Resource(source="package-constraints-ConfigurationViaXmlAndAnnotationsTest.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdeclaration/package-constraints-ConfigurationViaXmlAndAnnotationsTest.xml")
public class ConfigurationViaXmlAndAnnotationsTest
extends AbstractTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.1.1", id="e"), @SpecAssertion(section="7.1.1", id="a")})
    public void testEntityConfiguredViaAnnotationsAndXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Package.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"The bean should be constrained");
        Assert.assertEquals((int)beanDescriptor.getConstraintsForProperty("maxWeight").getConstraintDescriptors().size(), (int)2, (String)"With xml configuration there should be two constraints.");
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.ignoreXmlConfiguration();
        validator = config.buildValidatorFactory().getValidator();
        beanDescriptor = validator.getConstraintsForClass(Package.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Without xml there should be only one constraint.");
        Assert.assertEquals((int)beanDescriptor.getConstraintsForProperty("maxWeight").getConstraintDescriptors().size(), (int)1, (String)"Without xml there should be only one constraint.");
    }

    @Test
    @SpecAssertion(section="7.1.1.1", id="e")
    public void testDefaultGroupDefinitionDefinedInEntityApplies() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Package p = new Package();
        p.setMaxWeight(30);
        Set violations = validator.validate((Object)p, new Class[]{Default.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "ValidPackage defined as annotation");
    }
}

