/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.xmlconfiguration.constraintdeclaration;

import javax.validation.Configuration;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.constraintdeclaration.Package;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.jsr303.ValidationXml;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
@ValidationXml(value="validation-ConstraintDeclarationTest.xml")
@Resource(source="package-constraints-ConstraintDeclarationTest.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdeclaration/package-constraints-ConstraintDeclarationTest.xml")
public class ConstraintDeclarationTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="7.1.1", id="d")
    public void testConstraintAnnotationsArePerDefaultIgnoredForXmlConfiguredEntities() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Package.class);
        Assert.assertFalse((boolean)beanDescriptor.isBeanConstrained(), (String)"With xml configuration there should be no constraint.");
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.ignoreXmlConfiguration();
        validator = config.buildValidatorFactory().getValidator();
        beanDescriptor = validator.getConstraintsForClass(Package.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"If xml configuration is ignored Package should have a single constraint.");
    }
}

