/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.xmlconfiguration.constraintdeclaration.clazzlevel;

import java.util.Set;
import javax.validation.Configuration;
import javax.validation.Validator;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.constraintdeclaration.clazzlevel.Package;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
@Resources(value={@Resource(source="package-constraints-ClassLevelOverridingTest.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdeclaration/clazzlevel/package-constraints-ClassLevelOverridingTest.xml"), @Resource(source="package-constraints-ClassLevelOverridingImplicitOverrideTest.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdeclaration/clazzlevel/package-constraints-ClassLevelOverridingImplicitOverrideTest.xml"), @Resource(source="package-constraints-ClassLevelOverridingWithAnnotationTest.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdeclaration/clazzlevel/package-constraints-ClassLevelOverridingWithAnnotationTest.xml")})
public class ClassLevelOverridingTest
extends AbstractTest {
    public static final String packageName = "/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdeclaration/clazzlevel/";
    public static final String mappingFile1 = "package-constraints-ClassLevelOverridingTest.xml";
    public static final String mappingFile2 = "package-constraints-ClassLevelOverridingImplicitOverrideTest.xml";
    public static final String mappingFile3 = "package-constraints-ClassLevelOverridingWithAnnotationTest.xml";

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.1.1.1", id="a"), @SpecAssertion(section="7.1.1.1", id="c")})
    public void testIgnoreClassLevelAnnotations() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdeclaration/clazzlevel/package-constraints-ClassLevelOverridingTest.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        Package p = new Package();
        Set violations = validator.validate((Object)p, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "ValidPackage defined in XML");
    }

    @Test
    @SpecAssertion(section="7.1.1.1", id="b")
    public void testIgnoreAnnotationsFromEnclosingBeanIsApplied() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdeclaration/clazzlevel/package-constraints-ClassLevelOverridingImplicitOverrideTest.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        Package p = new Package();
        Set violations = validator.validate((Object)p, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "ValidPackage defined in XML");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.1.1.1", id="a"), @SpecAssertion(section="7.1.1.1", id="d")})
    public void testClassLevelAnnotationsApplied() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdeclaration/clazzlevel/package-constraints-ClassLevelOverridingWithAnnotationTest.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        Package p = new Package();
        Set violations = validator.validate((Object)p, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "ValidPackage defined in XML", "ValidPackage defined as annotation");
    }
}

