/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.xmlconfiguration.constraintdefinition;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.Validator;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.jsr303.tck.tests.xmlconfiguration.constraintdefinition.Name;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
@Resources(value={@Resource(source="constraint-definition-ExludeExistingValidatorsTest.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdefinition/constraint-definition-ExludeExistingValidatorsTest.xml"), @Resource(source="constraint-definition-IncludeExistingValidatorsTest.xml", destination="WEB-INF/classes/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdefinition/constraint-definition-IncludeExistingValidatorsTest.xml")})
public class XmlConfiguredConstraintValidatorTest
extends AbstractTest {
    public static final String packageName = "/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdefinition/";
    public static final String mappingFile1 = "constraint-definition-ExludeExistingValidatorsTest.xml";
    public static final String mappingFile2 = "constraint-definition-IncludeExistingValidatorsTest.xml";

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.1.2", id="b"), @SpecAssertion(section="7.1.2", id="e")})
    public <T extends Annotation> void testExcludeExistingValidators() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdefinition/constraint-definition-ExludeExistingValidatorsTest.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        PropertyDescriptor propDescriptor = validator.getConstraintsForClass(Name.class).getConstraintsForProperty("name");
        Set descriptors = propDescriptor.getConstraintDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)1, (String)"There should only be one constraint.");
        ConstraintDescriptor descriptor = (ConstraintDescriptor)descriptors.iterator().next();
        List validators = descriptor.getConstraintValidatorClasses();
        Assert.assertEquals((int)validators.size(), (int)0, (String)"No xml defined validator and annotations are ignored -> no validator");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.1.2", id="c"), @SpecAssertion(section="7.1.2", id="d"), @SpecAssertion(section="7.1.2", id="e")})
    public <T extends Annotation> void testIncludeExistingValidators() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/jsr303/tck/tests/xmlconfiguration/constraintdefinition/constraint-definition-IncludeExistingValidatorsTest.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        PropertyDescriptor propDescriptor = validator.getConstraintsForClass(Name.class).getConstraintsForProperty("name");
        Set descriptors = propDescriptor.getConstraintDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)1, (String)"There should only be one constraint.");
        ConstraintDescriptor descriptor = (ConstraintDescriptor)descriptors.iterator().next();
        List validators = descriptor.getConstraintValidatorClasses();
        Assert.assertEquals((int)validators.size(), (int)2, (String)"One validator should be defined in annotation and one in xml");
    }
}

