/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import org.jboss.testharness.api.DeploymentException;
import org.jboss.testharness.spi.StandaloneContainers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneContainersImpl
implements StandaloneContainers {
    public void deploy(Iterable<Class<?>> classes) throws DeploymentException {
    }

    public void undeploy() {
    }

    public void setup() {
    }

    public void cleanup() {
    }

    public void deploy(Collection<Class<?>> classes) throws DeploymentException {
    }

    public boolean deploy(Collection<Class<?>> classes, Collection<URL> validationXmls) {
        if (validationXmls == null || !validationXmls.iterator().hasNext()) {
            Thread.currentThread().setContextClassLoader(new IgnoringValidationXmlClassLoader());
            return true;
        }
        URL validationXmlUrl = validationXmls.iterator().next();
        Thread.currentThread().setContextClassLoader(new CustomValidationXmlClassLoader(validationXmlUrl.getPath()));
        return true;
    }

    public DeploymentException getDeploymentException() {
        return null;
    }

    private static class IgnoringValidationXmlClassLoader
    extends ClassLoader {
        IgnoringValidationXmlClassLoader() {
            super(IgnoringValidationXmlClassLoader.class.getClassLoader());
        }

        public InputStream getResourceAsStream(String path) {
            if ("META-INF/validation.xml".equals(path)) {
                return null;
            }
            return super.getResourceAsStream(path);
        }
    }

    private static class CustomValidationXmlClassLoader
    extends ClassLoader {
        private final String customValidationXmlPath;

        CustomValidationXmlClassLoader(String pathToCustomValidationXml) {
            super(CustomValidationXmlClassLoader.class.getClassLoader());
            this.customValidationXmlPath = pathToCustomValidationXml;
        }

        public InputStream getResourceAsStream(String path) {
            InputStream in;
            if ("META-INF/validation.xml".equals(path)) {
                if (this.customValidationXmlPath.contains(".jar!")) {
                    path = this.customValidationXmlPath.substring(this.customValidationXmlPath.indexOf("!") + 2);
                    in = super.getResourceAsStream(path);
                } else {
                    in = this.loadFromDisk();
                }
            } else {
                in = super.getResourceAsStream(path);
            }
            return in;
        }

        private InputStream loadFromDisk() {
            BufferedInputStream in;
            try {
                in = new BufferedInputStream(new FileInputStream(this.customValidationXmlPath));
            }
            catch (IOException ioe) {
                String msg = "Unble to load " + this.customValidationXmlPath + " from  disk";
                throw new RuntimeException(msg);
            }
            return in;
        }
    }
}

