/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.models.ModelsException;
import org.hibernate.models.internal.AbstractAnnotationDescriptorRegistry;
import org.hibernate.models.internal.ModelsAnnotationLogging;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;

public class AnnotationDescriptorRegistryImmutable
extends AbstractAnnotationDescriptorRegistry {
    public AnnotationDescriptorRegistryImmutable(Map<Class<? extends Annotation>, AnnotationDescriptor<?>> descriptorMap, Map<AnnotationDescriptor<?>, AnnotationDescriptor<?>> repeatableByContainerMap) {
        super(descriptorMap, repeatableByContainerMap);
        ModelsAnnotationLogging.MODELS_ANNOTATION_LOGGER.debugf("Created immutable AnnotationDescriptorRegistry", new Object[0]);
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> getDescriptor(Class<A> javaType) {
        return this.resolveDescriptor(javaType, null);
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> resolveDescriptor(Class<A> javaType, AnnotationDescriptorRegistry.DescriptorCreator<A> creator) {
        AnnotationDescriptor descriptor = (AnnotationDescriptor)this.descriptorMap.get(javaType);
        if (descriptor == null) {
            throw new ModelsException("AnnotationDescriptorRegistry is immutable - " + javaType.getName());
        }
        return descriptor;
    }

    @Override
    public AnnotationDescriptorRegistry makeImmutableCopy() {
        return this;
    }
}

