/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.reflect.Array;
import org.hibernate.models.internal.AbstractTypeDescriptor;
import org.hibernate.models.internal.jandex.EnumValueConverter;
import org.hibernate.models.internal.jandex.EnumValueExtractor;
import org.hibernate.models.spi.JandexValueConverter;
import org.hibernate.models.spi.JandexValueExtractor;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class EnumTypeDescriptor<E extends Enum<E>>
extends AbstractTypeDescriptor<E> {
    private final Class<E> enumType;
    private final EnumValueConverter<E> jandexWrapper;
    private final EnumValueExtractor<E> jandexExtractor;

    public EnumTypeDescriptor(Class<E> enumType) {
        this.enumType = enumType;
        this.jandexWrapper = new EnumValueConverter<E>(enumType);
        this.jandexExtractor = new EnumValueExtractor<E>(this.jandexWrapper);
    }

    @Override
    public Class<E> getValueType() {
        return this.enumType;
    }

    @Override
    public JandexValueConverter<E> createJandexValueConverter(SourceModelBuildingContext modelContext) {
        return this.jandexWrapper;
    }

    @Override
    public JandexValueExtractor<E> createJandexValueExtractor(SourceModelBuildingContext modelContext) {
        return this.jandexExtractor;
    }

    @Override
    public Object unwrap(E value) {
        return value;
    }

    @Override
    public E[] makeArray(int size, SourceModelBuildingContext modelContext) {
        return (Enum[])Array.newInstance(this.enumType, size);
    }
}

