/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.models.internal.AnnotationDescriptorRegistryStandard;
import org.hibernate.models.internal.BaseLineJavaTypes;
import org.hibernate.models.internal.ClassDetailsRegistryStandard;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.RegistryPrimer;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.IndexView;

public class SourceModelBuildingContextImpl
implements SourceModelBuildingContext {
    private final ClassLoading classLoadingAccess;
    private final IndexView jandexIndex;
    private final AnnotationDescriptorRegistryStandard descriptorRegistry;
    private final ClassDetailsRegistryStandard classDetailsRegistry;

    public SourceModelBuildingContextImpl(ClassLoading classLoadingAccess, IndexView jandexIndex) {
        this(classLoadingAccess, jandexIndex, null);
    }

    public SourceModelBuildingContextImpl(ClassLoading classLoadingAccess, IndexView jandexIndex, RegistryPrimer registryPrimer) {
        this.classLoadingAccess = classLoadingAccess;
        this.jandexIndex = jandexIndex;
        this.descriptorRegistry = new AnnotationDescriptorRegistryStandard(this);
        this.classDetailsRegistry = new ClassDetailsRegistryStandard(this);
        this.primeRegistries(registryPrimer);
    }

    @Override
    public AnnotationDescriptorRegistry getAnnotationDescriptorRegistry() {
        return this.descriptorRegistry;
    }

    @Override
    public ClassDetailsRegistry getClassDetailsRegistry() {
        return this.classDetailsRegistry;
    }

    @Override
    public ClassLoading getClassLoading() {
        return this.classLoadingAccess;
    }

    @Override
    public IndexView getJandexIndex() {
        return this.jandexIndex;
    }

    @Override
    public <A extends Annotation> List<A> getAllAnnotationUsages(Class<A> annotationType) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public <A extends Annotation> void forEachAnnotationUsage(Class<A> annotationType, Consumer<A> consumer) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void primeRegistries(RegistryPrimer registryPrimer) {
        BaseLineJavaTypes.forEachJavaType(this::primeClassDetails);
        if (registryPrimer != null) {
            registryPrimer.primeRegistries(new RegistryContributions(), this);
        }
    }

    private void primeClassDetails(Class<?> javaType) {
        this.classDetailsRegistry.resolveClassDetails(javaType.getName(), name -> JdkBuilders.buildClassDetailsStatic(javaType, (SourceModelBuildingContext)this));
    }

    private <A extends Annotation> void primeAnnotation(AnnotationDescriptor<A> descriptor) {
        this.descriptorRegistry.register(descriptor);
        this.primeClassDetails(descriptor.getAnnotationType());
    }

    private class RegistryContributions
    implements RegistryPrimer.Contributions {
        private RegistryContributions() {
        }

        @Override
        public <A extends Annotation> void registerAnnotation(AnnotationDescriptor<A> descriptor) {
            SourceModelBuildingContextImpl.this.primeAnnotation(descriptor);
        }

        @Override
        public void registerClass(ClassDetails details) {
            SourceModelBuildingContextImpl.this.classDetailsRegistry.addClassDetails(details);
        }
    }
}

