/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.hibernate.models.AnnotationAccessException;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.JdkValueExtractor;
import org.hibernate.models.spi.SourceModelBuildingContext;

public abstract class AbstractJdkValueExtractor<V>
implements JdkValueExtractor<V> {
    @Override
    public <A extends Annotation> V extractValue(A usage, AttributeDescriptor<V> attributeDescriptor, SourceModelBuildingContext modelContext) {
        try {
            Object rawValue = attributeDescriptor.getAttributeMethod().invoke(usage, new Object[0]);
            return (V)this.wrap(rawValue, attributeDescriptor, modelContext);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AnnotationAccessException(String.format(Locale.ROOT, "Unable to extract attribute value [%s] from annotation [%s]", attributeDescriptor.getName(), usage), e);
        }
    }

    @Override
    public V extractValue(Annotation annotation, String attributeName, SourceModelBuildingContext buildingContext) {
        AnnotationDescriptor<? extends Annotation> annDescriptor = buildingContext.getAnnotationDescriptorRegistry().getDescriptor(annotation.annotationType());
        return this.extractValue(annotation, annDescriptor.getAttribute(attributeName), buildingContext);
    }

    protected abstract V wrap(V var1, AttributeDescriptor<V> var2, SourceModelBuildingContext var3);
}

