/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.List;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.UnknownAnnotationAttributeException;
import org.hibernate.models.internal.AnnotationHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.RenderingCollector;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public interface AnnotationDescriptor<A extends Annotation>
extends AnnotationTarget {
    @Override
    default public AnnotationTarget.Kind getKind() {
        return AnnotationTarget.Kind.ANNOTATION;
    }

    public Class<A> getAnnotationType();

    public A createUsage(SourceModelBuildingContext var1);

    public A createUsage(A var1, SourceModelBuildingContext var2);

    public A createUsage(AnnotationInstance var1, SourceModelBuildingContext var2);

    public EnumSet<AnnotationTarget.Kind> getAllowableTargets();

    public boolean isInherited();

    default public boolean isRepeatable() {
        return this.getRepeatableContainer() != null;
    }

    public AnnotationDescriptor<?> getRepeatableContainer();

    public List<AttributeDescriptor<?>> getAttributes();

    default public <V> AttributeDescriptor<V> findAttribute(String name) {
        List<AttributeDescriptor<?>> attributeDescriptors = this.getAttributes();
        for (AttributeDescriptor<?> attributeDescriptor : attributeDescriptors) {
            if (!attributeDescriptor.getName().equals(name)) continue;
            return attributeDescriptor;
        }
        return null;
    }

    default public <V> AttributeDescriptor<V> getAttribute(String name) {
        AttributeDescriptor<V> attribute = this.findAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        throw new UnknownAnnotationAttributeException(this.getAnnotationType(), name);
    }

    default public <X extends Annotation> AnnotationDescriptor<X> asAnnotationDescriptor() {
        return this;
    }

    @Override
    default public ClassDetails asClassDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to a ClassDetails");
    }

    @Override
    default public MemberDetails asMemberDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to a MemberDetails");
    }

    @Override
    default public FieldDetails asFieldDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to a FieldDetails");
    }

    @Override
    default public MethodDetails asMethodDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to a MethodDetails");
    }

    @Override
    default public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("AnnotationDescriptor cannot be cast to a RecordComponentDetails");
    }

    @Override
    default public void render(SourceModelBuildingContext modelContext) {
        throw new UnsupportedOperationException("Rendering of annotation classes not implemented");
    }

    @Override
    default public void render(RenderingCollector collector, SourceModelBuildingContext modelContext) {
        throw new UnsupportedOperationException("Rendering of annotation classes not implemented");
    }

    default public void renderUsage(RenderingCollector collector, A usage, SourceModelBuildingContext modelContext) {
        AnnotationHelper.render(collector, usage, this, modelContext);
    }

    default public void renderUsage(RenderingCollector collector, String name, A usage, SourceModelBuildingContext modelContext) {
        AnnotationHelper.render(collector, name, usage, modelContext);
    }
}

