/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.type.impl;

import java.nio.ByteBuffer;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.BasicGridBinder;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueBinder;
import org.hibernate.ogm.type.descriptor.impl.GridValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class BufferingGridTypeDescriptor
implements GridTypeDescriptor {
    public static final BufferingGridTypeDescriptor INSTANCE = new BufferingGridTypeDescriptor();

    public <X> GridValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicGridBinder<X>(javaTypeDescriptor, this){

            protected void doBind(Tuple resultset, X value, String[] names, WrapperOptions options) {
                byte[] byteArray = (byte[])javaTypeDescriptor.unwrap(value, byte[].class, options);
                ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])byteArray.clone());
                resultset.put(names[0], (Object)byteBuffer);
            }
        };
    }

    public <X> GridValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new GridValueExtractor<X>(){

            public X extract(Tuple resultset, String name) {
                Object result = resultset.get(name);
                if (result == null) {
                    return null;
                }
                ByteBuffer byteBuffer = (ByteBuffer)result;
                byte[] byteArray = new byte[byteBuffer.remaining()];
                System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteArray, 0, byteArray.length);
                return javaTypeDescriptor.wrap((Object)byteArray, null);
            }
        };
    }
}

