/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.type.impl;

import java.util.Date;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.BasicGridBinder;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueBinder;
import org.hibernate.ogm.type.descriptor.impl.GridValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class TimeGridTypeDescriptor
implements GridTypeDescriptor {
    public static final TimeGridTypeDescriptor INSTANCE = new TimeGridTypeDescriptor();

    public <X> GridValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicGridBinder<X>(javaTypeDescriptor, this){

            protected void doBind(Tuple resultset, X value, String[] names, WrapperOptions options) {
                Date date = (Date)javaTypeDescriptor.unwrap(value, value.getClass(), options);
                long millisSinceMidnight = date.getTime() % 86400000L;
                long nanosSinceMidnight = millisSinceMidnight * 1000000L;
                resultset.put(names[0], (Object)nanosSinceMidnight);
            }
        };
    }

    public <X> GridValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new GridValueExtractor<X>(){

            public X extract(Tuple resultset, String name) {
                Object result = resultset.get(name);
                if (result == null) {
                    return null;
                }
                long nanosSinceMidnight = (Long)result;
                long millisSinceMidnight = nanosSinceMidnight / 1000000L;
                Date date = new Date(millisSinceMidnight);
                return javaTypeDescriptor.wrap((Object)date, null);
            }
        };
    }
}

