/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.cfg.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.hibernate.ogm.util.impl.Contracts;

public class Hosts
implements Iterable<HostAndPort> {
    public static Hosts NO_HOST = new Hosts(Collections.emptyList(), Collections.emptyList());
    private static Pattern LIKELY_IPV6 = Pattern.compile("^[\\d\\.:a-fA-F]$");
    private List<HostAndPort> hostsAndPorts;

    public Hosts(List<String> hosts, List<Integer> ports) {
        int length = hosts.size();
        Contracts.assertTrue(length == ports.size(), "Not the same number of hosts and ports");
        this.hostsAndPorts = new ArrayList<HostAndPort>(length);
        for (int i = 0; i < length; ++i) {
            this.hostsAndPorts.add(new HostAndPort(hosts.get(i), ports.get(i)));
        }
    }

    public boolean hasHost() {
        return this.hostsAndPorts.size() != 0;
    }

    public boolean isSingleHost() {
        return this.hostsAndPorts.size() == 1;
    }

    public int size() {
        return this.hostsAndPorts.size();
    }

    public HostAndPort getFirst() {
        Contracts.assertTrue(this.hasHost(), "getFirst called on an empty Hosts iterator");
        return this.hostsAndPorts.get(0);
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        for (HostAndPort hostAndPort : this.hostsAndPorts) {
            String host = hostAndPort.getHost();
            boolean matches = LIKELY_IPV6.matcher(host).matches();
            if (matches) {
                toString.append("[");
            }
            toString.append(hostAndPort.getHost());
            if (matches) {
                toString.append("]");
            }
            toString.append(":").append(hostAndPort.getPort()).append(", ");
        }
        return toString.toString();
    }

    @Override
    public Iterator<HostAndPort> iterator() {
        return this.hostsAndPorts.iterator();
    }

    public static class HostAndPort {
        private String host;
        private Integer port;

        public HostAndPort(String host, Integer port) {
            Contracts.assertNotNull(host, "host");
            Contracts.assertNotNull(host, "port");
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }
    }
}

