/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.document.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.spi.Tuple;

public class EmbeddableStateFinder {
    private final Tuple tuple;
    private final List<String> columns;
    private Set<String> nullEmbeddables = new HashSet<String>();
    private Map<String, String> columnToOuterMostNullEmbeddableCache = new HashMap<String, String>();

    public EmbeddableStateFinder(Tuple tuple, TupleContext tupleContext) {
        this.tuple = tuple;
        this.columns = tupleContext.getSelectableColumns();
    }

    public String getOuterMostNullEmbeddableIfAny(String column) {
        String[] path = column.split("\\.");
        if (!this.isEmbeddableColumn(path)) {
            return null;
        }
        if (this.columnToOuterMostNullEmbeddableCache.containsKey(column)) {
            return this.columnToOuterMostNullEmbeddableCache.get(column);
        }
        return this.determineAndCacheOuterMostNullEmbeddable(column, path);
    }

    private String determineAndCacheOuterMostNullEmbeddable(String column, String[] path) {
        String embeddable = path[0];
        for (int index = 0; index < path.length - 1; ++index) {
            Set<String> columnsOfEmbeddable = this.getColumnsOfEmbeddableAndComputeEmbeddableNullness(embeddable);
            if (this.nullEmbeddables.contains(embeddable)) {
                for (String columnOfEmbeddable : columnsOfEmbeddable) {
                    this.columnToOuterMostNullEmbeddableCache.put(columnOfEmbeddable, embeddable);
                }
                break;
            }
            this.maybeCacheOnNonNullEmbeddable(path, index, columnsOfEmbeddable);
            embeddable = embeddable + "." + path[index + 1];
        }
        return this.columnToOuterMostNullEmbeddableCache.get(column);
    }

    private void maybeCacheOnNonNullEmbeddable(String[] path, int index, Set<String> columnsOfEmbeddable) {
        if (index == path.length - 2) {
            for (String columnInvolved : columnsOfEmbeddable) {
                if (columnInvolved.split("\\.").length != path.length) continue;
                this.columnToOuterMostNullEmbeddableCache.put(columnInvolved, null);
            }
        }
    }

    private Set<String> getColumnsOfEmbeddableAndComputeEmbeddableNullness(String embeddable) {
        HashSet<String> columnsOfEmbeddable = new HashSet<String>();
        boolean hasOnlyNullColumns = true;
        for (String selectableColumn : this.columns) {
            if (!this.isColumnPartOfEmbeddable(embeddable, selectableColumn)) continue;
            columnsOfEmbeddable.add(selectableColumn);
            if (!hasOnlyNullColumns || this.tuple.get(selectableColumn) == null) continue;
            hasOnlyNullColumns = false;
        }
        if (hasOnlyNullColumns) {
            this.nullEmbeddables.add(embeddable);
        }
        return columnsOfEmbeddable;
    }

    private boolean isColumnPartOfEmbeddable(String embeddable, String selectableColumn) {
        return selectableColumn.startsWith(embeddable);
    }

    private boolean isEmbeddableColumn(String[] path) {
        return path.length >= 2;
    }
}

