/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.map.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.persistence.PessimisticLockException;
import org.hibernate.ogm.datastore.map.impl.MapDialect;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public final class MapDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable {
    private static final Log log = LoggerFactory.make();
    private final ConcurrentMap<EntityKey, Map<String, Object>> entitiesKeyValueStorage = CollectionHelper.newConcurrentHashMap();
    private final ConcurrentMap<AssociationKey, Map<RowKey, Map<String, Object>>> associationsKeyValueStorage = CollectionHelper.newConcurrentHashMap();
    private final ConcurrentMap<IdSourceKey, AtomicInteger> sequencesStorage = CollectionHelper.newConcurrentHashMap();
    private final ConcurrentMap<Object, ReadWriteLock> dataLocks = CollectionHelper.newConcurrentHashMap();
    private final ThreadLocal<Set<Lock>> acquiredLocksPerThread = new ThreadLocal<Set<Lock>>(){

        @Override
        protected Set<Lock> initialValue() {
            return new HashSet<Lock>();
        }
    };

    @Override
    public Class<? extends GridDialect> getDefaultDialect() {
        return MapDialect.class;
    }

    public void stop() {
        this.entitiesKeyValueStorage.clear();
        this.associationsKeyValueStorage.clear();
        this.sequencesStorage.clear();
        this.dataLocks.clear();
        this.acquiredLocksPerThread.remove();
        log.debug("Stopped and cleared MapDatastoreProvider");
    }

    public void start() {
        log.debug("MapDatastoreProvider started");
    }

    public void writeLock(EntityKey key, int timeout) {
        ReadWriteLock lock = this.getLock(key);
        Lock writeLock = lock.writeLock();
        this.acquireLock(key, timeout, writeLock);
    }

    public void readLock(EntityKey key, int timeout) {
        ReadWriteLock lock = this.getLock(key);
        Lock readLock = lock.readLock();
        this.acquireLock(key, timeout, readLock);
    }

    private ReadWriteLock getLock(EntityKey key) {
        ReentrantReadWriteLock newLock = new ReentrantReadWriteLock();
        ReadWriteLock previous = this.dataLocks.putIfAbsent(key, newLock);
        return previous != null ? previous : newLock;
    }

    private void acquireLock(EntityKey key, int timeout, Lock writeLock) {
        try {
            if (timeout == -1) {
                writeLock.lockInterruptibly();
            } else if (timeout == 0) {
                boolean locked = writeLock.tryLock();
                if (!locked) {
                    throw new PessimisticLockException("lock on key " + key + " was not available");
                }
            } else {
                writeLock.tryLock(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            throw new PessimisticLockException("timed out waiting for lock on key " + key, (Throwable)e);
        }
        this.acquiredLocksPerThread.get().add(writeLock);
    }

    public void putEntity(EntityKey key, Map<String, Object> tuple) {
        this.entitiesKeyValueStorage.put(key, tuple);
    }

    public Map<String, Object> getEntityTuple(EntityKey key) {
        return (Map)this.entitiesKeyValueStorage.get(key);
    }

    public List<Map<String, Object>> getEntityTuples(EntityKey ... keys) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(keys.length);
        for (EntityKey key : keys) {
            results.add((Map<String, Object>)this.entitiesKeyValueStorage.get(key));
        }
        return results;
    }

    public void removeEntityTuple(EntityKey key) {
        this.entitiesKeyValueStorage.remove(key);
    }

    public void putAssociation(AssociationKey key, Map<RowKey, Map<String, Object>> associationMap) {
        this.associationsKeyValueStorage.put(key, associationMap);
    }

    public Map<RowKey, Map<String, Object>> getAssociation(AssociationKey key) {
        return (Map)this.associationsKeyValueStorage.get(key);
    }

    public void removeAssociation(AssociationKey key) {
        this.associationsKeyValueStorage.remove(key);
    }

    public int getSharedAtomicInteger(IdSourceKey key, int initialValue, int increment) {
        AtomicInteger valueProposal = new AtomicInteger(initialValue);
        AtomicInteger previous = this.sequencesStorage.putIfAbsent(key, valueProposal);
        return previous == null ? initialValue : previous.addAndGet(increment);
    }

    public Map<EntityKey, Map<String, Object>> getEntityMap() {
        return Collections.unmodifiableMap(this.entitiesKeyValueStorage);
    }

    public Map<AssociationKey, Map<RowKey, Map<String, Object>>> getAssociationsMap() {
        return Collections.unmodifiableMap(this.associationsKeyValueStorage);
    }

    @Override
    public boolean allowsTransactionEmulation() {
        return true;
    }
}

