/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.eventstate.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.ogm.dialect.eventstate.impl.EventStateLifecycle;
import org.hibernate.ogm.dialect.eventstate.impl.EventStateLifecycles;
import org.hibernate.ogm.dialect.impl.BatchOperationsDelegator;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.service.Service;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class EventContextManager
implements Service {
    private final ThreadLocal<Map<Class<?>, Object>> stateHolder = new ThreadLocal();
    private final Map<Class<?>, EventStateLifecycle<?>> lifecycles = Collections.unmodifiableMap(EventStateLifecycles.getLifecycles());

    public static boolean isEventContextRequired(Map<Object, Object> settings, SessionFactoryServiceRegistry serviceRegistry) {
        GridDialect gridDialect = (GridDialect)serviceRegistry.getService(GridDialect.class);
        BatchOperationsDelegator batchDelegator = GridDialects.getDelegateOrNull(gridDialect, BatchOperationsDelegator.class);
        return settings.get("hibernate.ogm.error_handler") != null || batchDelegator != null;
    }

    void onEventBegin(EventSource session) {
        HashMap<Class<SessionImplementor>, EventSource> stateMap = new HashMap<Class<SessionImplementor>, EventSource>();
        stateMap.put(SessionImplementor.class, session);
        this.stateHolder.set(stateMap);
    }

    void onEventFinished() {
        Map<Class<?>, Object> states = this.stateHolder.get();
        if (states == null) {
            return;
        }
        SessionImplementor session = (SessionImplementor)states.get(SessionImplementor.class);
        for (Map.Entry<Class<?>, Object> state : states.entrySet()) {
            if (state.getValue() == session) continue;
            this.onFinish(state.getKey(), state.getValue(), session);
        }
        this.stateHolder.remove();
    }

    private <T> void onFinish(Class<T> stateType, Object state, SessionImplementor session) {
        Object typedState = state;
        this.getLifecycle(stateType).onFinish(typedState, session);
    }

    public <T> T get(Class<T> stateType) {
        Map<Class<?>, Object> states = this.getStates();
        T value = this.getState(states, stateType);
        if (value == null) {
            value = this.create(stateType, states);
            states.put(stateType, value);
        }
        return value;
    }

    public boolean isActive() {
        return this.stateHolder.get() != null;
    }

    private <T> T create(Class<T> stateType, Map<Class<?>, Object> states) {
        EventStateLifecycle<T> lifeycle = this.getLifecycle(stateType);
        if (lifeycle == null) {
            throw new IllegalStateException("No lifecycle found for state type: " + stateType);
        }
        SessionImplementor session = this.getState(states, SessionImplementor.class);
        return lifeycle.create(session);
    }

    private Map<Class<?>, Object> getStates() {
        Map<Class<?>, Object> states = this.stateHolder.get();
        if (states == null) {
            throw new IllegalStateException("Must not access event cycle state if not within a supported event cycle (flush, auto-flush, persist)");
        }
        return states;
    }

    private <T> T getState(Map<Class<?>, Object> states, Class<T> stateType) {
        Object value = states.get(stateType);
        return (T)value;
    }

    private <T> EventStateLifecycle<T> getLifecycle(Class<T> stateType) {
        EventStateLifecycle<?> lifecycle = this.lifecycles.get(stateType);
        return lifecycle;
    }
}

