/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.eventstate.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.compensation.impl.ErrorHandlerEnabledTransactionCoordinatorDecorator;
import org.hibernate.ogm.compensation.impl.OperationCollector;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.eventstate.impl.EventStateLifecycle;
import org.hibernate.ogm.dialect.impl.BatchOperationsDelegator;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.spi.GridDialect;

class EventStateLifecycles {
    private EventStateLifecycles() {
    }

    public static Map<Class<?>, EventStateLifecycle<?>> getLifecycles() {
        HashMap lifecycles = new HashMap();
        lifecycles.put(OperationCollector.class, OperationCollectorLifecycle.INSTANCE);
        lifecycles.put(OperationsQueue.class, OperationsQueueLifecycle.INSTANCE);
        return lifecycles;
    }

    private static class OperationsQueueLifecycle
    implements EventStateLifecycle<OperationsQueue> {
        private static EventStateLifecycle<?> INSTANCE = new OperationsQueueLifecycle();

        private OperationsQueueLifecycle() {
        }

        @Override
        public OperationsQueue create(SessionImplementor session) {
            return new OperationsQueue();
        }

        @Override
        public void onFinish(OperationsQueue state, SessionImplementor session) {
            GridDialect gridDialect = (GridDialect)session.getFactory().getServiceRegistry().getService(GridDialect.class);
            GridDialects.getDelegateOrNull(gridDialect, BatchOperationsDelegator.class).executeBatch();
        }
    }

    private static class OperationCollectorLifecycle
    implements EventStateLifecycle<OperationCollector> {
        private static EventStateLifecycle<?> INSTANCE = new OperationCollectorLifecycle();

        private OperationCollectorLifecycle() {
        }

        @Override
        public OperationCollector create(SessionImplementor session) {
            return ((ErrorHandlerEnabledTransactionCoordinatorDecorator)session.getTransactionCoordinator()).getOperationCollector();
        }

        @Override
        public void onFinish(OperationCollector state, SessionImplementor session) {
        }
    }
}

