/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.query.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.ogm.dialect.query.spi.RowSelection;
import org.hibernate.ogm.dialect.query.spi.TypedGridValue;
import org.hibernate.ogm.type.spi.TypeTranslator;

public class QueryParameters {
    private final RowSelection rowSelection;
    private final Map<String, TypedGridValue> namedParameters;
    private final List<TypedGridValue> positionalParameters;

    public QueryParameters(RowSelection rowSelection, Map<String, TypedGridValue> namedParameters, List<TypedGridValue> positionalParameters) {
        this.rowSelection = rowSelection;
        this.namedParameters = namedParameters;
        this.positionalParameters = positionalParameters;
    }

    public static QueryParameters fromOrmQueryParameters(org.hibernate.engine.spi.QueryParameters parameters, TypeTranslator typeTranslator) {
        RowSelection selection = RowSelection.fromOrmRowSelection(parameters.getRowSelection());
        HashMap<String, TypedGridValue> namedParameters = new HashMap<String, TypedGridValue>();
        for (Map.Entry parameter : parameters.getNamedParameters().entrySet()) {
            namedParameters.put((String)parameter.getKey(), TypedGridValue.fromOrmTypedValue((TypedValue)parameter.getValue(), typeTranslator));
        }
        ArrayList<TypedGridValue> positionalParameters = new ArrayList<TypedGridValue>(parameters.getPositionalParameterTypes().length);
        for (int i = 0; i < parameters.getPositionalParameterTypes().length; ++i) {
            positionalParameters.add(new TypedGridValue(typeTranslator.getType(parameters.getPositionalParameterTypes()[i]), parameters.getPositionalParameterValues()[i]));
        }
        return new QueryParameters(selection, namedParameters, positionalParameters);
    }

    public RowSelection getRowSelection() {
        return this.rowSelection;
    }

    public Map<String, TypedGridValue> getNamedParameters() {
        return this.namedParameters;
    }

    public List<TypedGridValue> getPositionalParameters() {
        return this.positionalParameters;
    }
}

