/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.entityentry.impl;

import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityEntryExtraState;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class OgmEntityEntryState
implements EntityEntryExtraState {
    private static final Log log = LoggerFactory.make();
    private EntityEntryExtraState next;
    private Tuple tuple;

    public Tuple getTuple() {
        return this.tuple;
    }

    public void setTuple(Tuple tuple) {
        this.tuple = tuple;
    }

    public static OgmEntityEntryState getStateFor(SessionImplementor session, Object object) {
        EntityEntry entityEntry = session.getPersistenceContext().getEntry(object);
        if (entityEntry == null) {
            throw log.cannotFindEntityEntryForEntity(object);
        }
        OgmEntityEntryState ogmEntityState = (OgmEntityEntryState)entityEntry.getExtraState(OgmEntityEntryState.class);
        if (ogmEntityState == null) {
            ogmEntityState = new OgmEntityEntryState();
            entityEntry.addExtraState((EntityEntryExtraState)ogmEntityState);
        }
        return ogmEntityState;
    }

    public void addExtraState(EntityEntryExtraState extraState) {
        if (this.next == null) {
            this.next = extraState;
        } else {
            this.next.addExtraState(extraState);
        }
    }

    public <T extends EntityEntryExtraState> T getExtraState(Class<T> extraStateType) {
        if (this.next == null) {
            return null;
        }
        if (extraStateType.isAssignableFrom(this.next.getClass())) {
            return (T)this.next;
        }
        return (T)this.next.getExtraState(extraStateType);
    }
}

