/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.massindex.impl;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.massindex.impl.SessionAwareRunnable;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class OptionallyWrapInJTATransaction
implements ModelConsumer {
    private static final Log log = LoggerFactory.make();
    private final SessionFactoryImplementor factory;
    private final SessionAwareRunnable delegate;
    private final ErrorHandler errorHandler;

    public OptionallyWrapInJTATransaction(SessionFactory factory, ErrorHandler errorHandler, SessionAwareRunnable sessionAwareRunnable) {
        this.factory = (SessionFactoryImplementor)factory;
        this.delegate = sessionAwareRunnable;
        this.errorHandler = errorHandler;
    }

    private TransactionManager getTransactionManager() {
        return ((JtaPlatform)this.factory.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
    }

    boolean wrapInTransaction() {
        TransactionCoordinatorBuilder transactionCoordinatorBuilder = (TransactionCoordinatorBuilder)this.factory.getServiceRegistry().getService(TransactionCoordinatorBuilder.class);
        if (!transactionCoordinatorBuilder.isJta()) {
            log.trace((Object)"TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction");
            return false;
        }
        TransactionManager transactionManager = this.getTransactionManager();
        if (transactionManager == null) {
            log.trace((Object)"No TransactionManager found, do not start a surrounding JTA transaction");
            return false;
        }
        try {
            if (transactionManager.getStatus() == 6) {
                log.trace((Object)"No Transaction in progress, needs to start a JTA transaction");
                return true;
            }
        }
        catch (SystemException e) {
            log.cannotGuessTransactionStatus((Exception)((Object)e));
            return false;
        }
        log.trace((Object)"Transaction in progress, no needs to start a JTA transaction");
        return false;
    }

    @Override
    public void consume(Tuple tuple) {
        try {
            boolean wrapInTransaction = this.wrapInTransaction();
            if (wrapInTransaction) {
                this.consumeInTransaction(tuple);
            } else {
                this.delegate.run(null, tuple);
            }
        }
        catch (Throwable e) {
            this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
        }
    }

    private void consumeInTransaction(Tuple tuple) {
        TransactionManager transactionManager = this.getTransactionManager();
        try {
            Session session = this.factory.openSession();
            transactionManager.begin();
            this.delegate.run(session, tuple);
            transactionManager.commit();
            session.close();
        }
        catch (Throwable e) {
            this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
            this.rollback(transactionManager, e);
        }
    }

    private void rollback(TransactionManager transactionManager, Throwable e) {
        try {
            transactionManager.rollback();
        }
        catch (SystemException e1) {
            log.errorRollingBackTransaction(e.getMessage(), (Exception)((Object)e1));
        }
    }
}

