/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.key.spi;

import java.util.Arrays;
import org.hibernate.AssertionFailure;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;

public final class AssociationKey {
    private final AssociationKeyMetadata metadata;
    private final Object[] columnValues;
    private final int hashCode;
    private final EntityKey entityKey;

    public AssociationKey(AssociationKeyMetadata metadata, Object[] columnValues, EntityKey entityKey) {
        this.metadata = metadata;
        if (metadata.getColumnNames().length != columnValues.length) {
            throw new AssertionFailure("Column names do not match column values");
        }
        this.columnValues = columnValues;
        this.entityKey = entityKey;
        this.hashCode = metadata.hashCode() * 31 + Arrays.hashCode(columnValues);
    }

    public AssociationKeyMetadata getMetadata() {
        return this.metadata;
    }

    public String getTable() {
        return this.metadata.getTable();
    }

    public String[] getColumnNames() {
        return this.metadata.getColumnNames();
    }

    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || AssociationKey.class != o.getClass()) {
            return false;
        }
        AssociationKey that = (AssociationKey)o;
        if (!this.metadata.getTable().equals(that.metadata.getTable())) {
            return false;
        }
        if (!Arrays.equals(this.columnValues, that.columnValues)) {
            return false;
        }
        return Arrays.equals(this.metadata.getColumnNames(), that.metadata.getColumnNames());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AssociationKey(");
        sb.append(this.getTable());
        sb.append(") [");
        int i = 0;
        for (String column : this.metadata.getColumnNames()) {
            sb.append(column).append("=").append(this.columnValues[i]);
            if (++i >= this.metadata.getColumnNames().length) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public Object getColumnValue(String columnName) {
        for (int i = 0; i < this.getColumnNames().length; ++i) {
            String name = this.getColumnNames()[i];
            if (!name.equals(columnName)) continue;
            return this.getColumnValues()[i];
        }
        throw new AssertionFailure(String.format("Given column %s is not part of this key: %s", columnName, this.toString()));
    }
}

