/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.ogm.datastore.impl.EmptyAssociationSnapshot;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.AssociationOperationType;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.util.impl.Contracts;
import org.hibernate.ogm.util.impl.StringHelper;

public class Association {
    private final AssociationSnapshot snapshot;
    private final Map<RowKey, AssociationOperation> currentState = new HashMap<RowKey, AssociationOperation>();
    private boolean cleared;

    public Association() {
        this.snapshot = EmptyAssociationSnapshot.INSTANCE;
    }

    public Association(AssociationSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public Tuple get(RowKey key) {
        AssociationOperation result = this.currentState.get(key);
        if (result == null) {
            return this.cleared ? null : this.snapshot.get(key);
        }
        if (result.getType() == AssociationOperationType.REMOVE) {
            return null;
        }
        return result.getValue();
    }

    public void put(RowKey key, Tuple value) {
        Contracts.assertNotNull(value, "association.put value");
        this.currentState.put(key, new AssociationOperation(key, value, AssociationOperationType.PUT));
    }

    public void remove(RowKey key) {
        this.currentState.put(key, new AssociationOperation(key, null, AssociationOperationType.REMOVE));
    }

    public List<AssociationOperation> getOperations() {
        ArrayList<AssociationOperation> result = new ArrayList<AssociationOperation>(this.currentState.size() + 1);
        if (this.cleared) {
            result.add(new AssociationOperation(null, null, AssociationOperationType.CLEAR));
        }
        result.addAll(this.currentState.values());
        return result;
    }

    public AssociationSnapshot getSnapshot() {
        return this.snapshot;
    }

    public boolean isEmpty() {
        int snapshotSize;
        int n = snapshotSize = this.cleared ? 0 : this.snapshot.size();
        if (snapshotSize == 0 && this.currentState.isEmpty()) {
            return true;
        }
        if (snapshotSize > this.currentState.size()) {
            return false;
        }
        return this.size() == 0;
    }

    public int size() {
        int size = this.cleared ? 0 : this.snapshot.size();
        for (Map.Entry<RowKey, AssociationOperation> op : this.currentState.entrySet()) {
            switch (op.getValue().getType()) {
                case PUT: {
                    if (!this.cleared && this.snapshot.containsKey(op.getKey())) break;
                    ++size;
                    break;
                }
                case REMOVE: {
                    if (this.cleared || !this.snapshot.containsKey(op.getKey())) break;
                    --size;
                }
            }
        }
        return size;
    }

    public Iterable<RowKey> getKeys() {
        if (this.currentState.isEmpty()) {
            if (this.cleared) {
                return Collections.emptyList();
            }
            return this.snapshot.getRowKeys();
        }
        HashSet<RowKey> keys = new HashSet<RowKey>(this.cleared ? this.currentState.size() : this.snapshot.size() + this.currentState.size());
        if (!this.cleared) {
            for (RowKey rowKey : this.snapshot.getRowKeys()) {
                keys.add(rowKey);
            }
        }
        for (Map.Entry entry : this.currentState.entrySet()) {
            switch (((AssociationOperation)entry.getValue()).getType()) {
                case PUT: {
                    keys.add((RowKey)entry.getKey());
                    break;
                }
                case REMOVE: {
                    keys.remove(entry.getKey());
                }
            }
        }
        return keys;
    }

    public void clear() {
        this.cleared = true;
        this.currentState.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Association[").append(StringHelper.lineSeparator());
        Iterator<RowKey> rowKeys = this.getKeys().iterator();
        while (rowKeys.hasNext()) {
            RowKey rowKey = rowKeys.next();
            sb.append("  ").append(rowKey).append("=").append(this.get(rowKey));
            if (!rowKeys.hasNext()) continue;
            sb.append(",").append(StringHelper.lineSeparator());
        }
        sb.append(StringHelper.lineSeparator()).append("]");
        return sb.toString();
    }
}

