/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.query.impl;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.QueryableGridDialect;
import org.hibernate.ogm.loader.nativeloader.impl.BackendCustomQuery;
import org.hibernate.ogm.type.spi.TypeTranslator;

class NativeNoSqlQueryPlan
extends NativeSQLQueryPlan {
    public NativeNoSqlQueryPlan(String sourceQuery, CustomQuery customQuery) {
        super(sourceQuery, customQuery);
    }

    public int performExecuteUpdate(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        QueryableGridDialect gridDialect = (QueryableGridDialect)session.getFactory().getServiceRegistry().getService(QueryableGridDialect.class);
        TypeTranslator typeTranslator = (TypeTranslator)session.getFactory().getServiceRegistry().getService(TypeTranslator.class);
        return this.performExecuteUpdateQuery(gridDialect, org.hibernate.ogm.dialect.query.spi.QueryParameters.fromOrmQueryParameters(queryParameters, typeTranslator));
    }

    private <T extends Serializable> int performExecuteUpdateQuery(QueryableGridDialect<T> gridDialect, org.hibernate.ogm.dialect.query.spi.QueryParameters queryParameters) {
        BackendCustomQuery customQuery = (BackendCustomQuery)this.getCustomQuery();
        BackendQuery backendQuery = new BackendQuery(customQuery.getQueryObject(), customQuery.getSingleEntityMetadataInformationOrNull());
        return gridDialect.executeBackendUpdateQuery(backendQuery, queryParameters);
    }
}

