/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.query.parsing.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class ParserPropertyHelper
implements PropertyHelper {
    private final SessionFactoryImplementor sessionFactory;
    private final EntityNamesResolver entityNames;

    public ParserPropertyHelper(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames) {
        this.sessionFactory = sessionFactory;
        this.entityNames = entityNames;
    }

    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        Type propertyType = this.getPropertyType(entityType, propertyPath);
        if (propertyType.isEntityType()) {
            throw new UnsupportedOperationException("Queries on associated entities are not supported yet.");
        }
        if (propertyType instanceof AbstractStandardBasicType) {
            return ((AbstractStandardBasicType)propertyType).fromString(value);
        }
        return value;
    }

    public Object convertToBackendType(String entityType, List<String> propertyPath, Object value) {
        Type propertyType = this.getPropertyType(entityType, propertyPath);
        GridType ogmType = ((TypeTranslator)this.sessionFactory.getServiceRegistry().getService(TypeTranslator.class)).getType(propertyType);
        return ogmType.convertToBackendType(value, this.sessionFactory);
    }

    protected Type getPropertyType(String entityType, List<String> propertyPath) {
        Iterator<String> pathIterator = propertyPath.iterator();
        OgmEntityPersister persister = this.getPersister(entityType);
        String propertyName = pathIterator.next();
        Type propertyType = persister.getPropertyType(propertyName);
        if (!pathIterator.hasNext()) {
            return propertyType;
        }
        if (propertyType.isComponentType()) {
            return this.getAssociationPropertyType(propertyType, pathIterator);
        }
        if (propertyType.isAssociationType()) {
            Joinable associatedJoinable = ((AssociationType)propertyType).getAssociatedJoinable(persister.getFactory());
            if (associatedJoinable.isCollection()) {
                OgmCollectionPersister collectionPersister = (OgmCollectionPersister)associatedJoinable;
                if (collectionPersister.getType().isComponentType()) {
                    return this.getAssociationPropertyType(collectionPersister.getType(), pathIterator);
                }
            } else if (propertyType.isEntityType()) {
                return this.getAssociationPropertyType(propertyType, pathIterator);
            }
        }
        throw new UnsupportedOperationException("Unrecognized property type: " + propertyType);
    }

    private Type getAssociationPropertyType(Type type, Iterator<String> pathIterator) {
        if (pathIterator.hasNext()) {
            String property = pathIterator.next();
            Type subType = this.associationPropertyType(type, property);
            if (subType.isComponentType()) {
                return this.getAssociationPropertyType(subType, pathIterator);
            }
            if (subType.isAssociationType()) {
                Joinable associatedJoinable = ((AssociationType)subType).getAssociatedJoinable(this.sessionFactory);
                if (!associatedJoinable.isCollection() && subType.isEntityType()) {
                    return this.getAssociationPropertyType(subType, pathIterator);
                }
                throw new UnsupportedOperationException("Queries on collection in embeddables are not supported: " + property);
            }
            return subType;
        }
        return type;
    }

    private Type associationPropertyType(Type type, String property) {
        if (type instanceof ComponentType) {
            ComponentType componentType = (ComponentType)type;
            return componentType.getSubtypes()[componentType.getPropertyIndex(property)];
        }
        if (type instanceof EntityType) {
            OgmEntityPersister persister = this.getPersister(type.getName());
            return persister.getPropertyType(property);
        }
        throw new UnsupportedOperationException("Unrecognized property type: " + type);
    }

    protected OgmEntityPersister getPersister(String entityType) {
        Class targetedType = this.entityNames.getClassFromName(entityType);
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        return (OgmEntityPersister)this.sessionFactory.getEntityPersister(targetedType.getName());
    }

    public boolean isEmbeddedProperty(String targetTypeName, List<String> namesWithoutAlias) {
        Joinable associatedJoinable;
        OgmEntityPersister persister = this.getPersister(targetTypeName);
        Type propertyType = persister.getPropertyType(namesWithoutAlias.get(0));
        if (propertyType.isComponentType()) {
            return true;
        }
        if (propertyType.isAssociationType() && (associatedJoinable = ((AssociationType)propertyType).getAssociatedJoinable(persister.getFactory())).isCollection()) {
            OgmCollectionPersister collectionPersister = (OgmCollectionPersister)associatedJoinable;
            return collectionPersister.getType().isComponentType();
        }
        return false;
    }

    public boolean isAssociation(String targetTypeName, List<String> pathWithoutAlias) {
        OgmEntityPersister persister = this.getPersister(targetTypeName);
        Type propertyType = persister.getPropertyType(pathWithoutAlias.get(0));
        return propertyType.isAssociationType();
    }

    public List<String> findAssociationPath(String targetTypeName, List<String> pathWithoutAlias) {
        ArrayList<String> subPath = new ArrayList<String>(pathWithoutAlias.size());
        for (String name : pathWithoutAlias) {
            subPath.add(name);
            if (!this.isAssociation(targetTypeName, subPath)) continue;
            return subPath;
        }
        return null;
    }

    public boolean isNestedProperty(List<String> propertyPathWithoutAlias) {
        return propertyPathWithoutAlias.size() > 1;
    }

    public boolean isSimpleProperty(List<String> propertyPathWithoutAlias) {
        return propertyPathWithoutAlias.size() == 1;
    }

    protected String getColumn(OgmEntityPersister persister, List<String> propertyPath) {
        OgmCollectionPersister collectionPersister;
        Joinable associatedJoinable;
        Iterator<String> pathIterator = propertyPath.iterator();
        String propertyName = pathIterator.next();
        Type propertyType = persister.getPropertyType(propertyName);
        if (!pathIterator.hasNext()) {
            return persister.getPropertyColumnNames(propertyName)[0];
        }
        if (propertyType.isComponentType()) {
            String componentPropertyName = StringHelper.join(propertyPath, ".");
            return persister.getPropertyColumnNames(componentPropertyName)[0];
        }
        if (propertyType.isAssociationType() && (associatedJoinable = ((AssociationType)propertyType).getAssociatedJoinable(persister.getFactory())).isCollection() && (collectionPersister = (OgmCollectionPersister)associatedJoinable).getType().isComponentType()) {
            StringBuilder columnNameBuilder = new StringBuilder();
            this.appendComponentCollectionPath(columnNameBuilder, collectionPersister, pathIterator);
            return columnNameBuilder.toString();
        }
        throw new UnsupportedOperationException("Unrecognized property type: " + propertyType);
    }

    private void appendComponentCollectionPath(StringBuilder columnNameBuilder, OgmCollectionPersister persister, Iterator<String> pathIterator) {
        if (pathIterator.hasNext()) {
            String property = pathIterator.next();
            Type subType = this.associationPropertyType(persister.getType(), property);
            if (subType.isComponentType()) {
                property = property + "." + StringHelper.join(pathIterator, ".");
            } else if (subType.isAssociationType()) {
                throw new UnsupportedOperationException("Queries on collection in embeddables are not supported: " + property);
            }
            columnNameBuilder.append(persister.toColumns(property)[0]);
        }
    }

    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

